<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "payment_plan_hs" table
 */
#[Entity]
#[Table(name: "payment_plan_hs")]
class PaymentPlanH extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $grp;

    #[Column(name: "s_grp", type: "smallint")]
    private int $sGrp;

    #[Column(type: "smallint")]
    private int $godown;

    #[Column(type: "smallint")]
    private int $rid;

    #[Column(name: "batch_no", type: "smallint")]
    private int $batchNo;

    #[Column(type: "smallint")]
    private int $count;

    #[Column(type: "smallint")]
    private int $twist;

    #[Column(name: "min_tolerance", type: "smallint")]
    private int $minTolerance;

    #[Column(name: "max_tolerance", type: "string")]
    private string $maxTolerance;

    #[Column(type: "string")]
    private string $description;

    #[Column(name: "yes_no", type: "integer")]
    private int $yesNo;

    #[Column(name: "`@`", options: ["name" => "@"], type: "integer")]
    private int $40;

    #[Column(name: "shortage_deduction", type: "float")]
    private float $shortageDeduction;

    #[Column(type: "integer")]
    private int $status;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(type: "string")]
    private string $method;

    public function __construct()
    {
        $this->grp = 2;
        $this->sGrp = 23;
        $this->godown = (isset($_COOKIE["User_Site"]))? $_COOKIE["User_Site"]:"";
        $this->status = 1;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getGrp(): int
    {
        return $this->grp;
    }

    public function setGrp(int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): int
    {
        return $this->sGrp;
    }

    public function setSGrp(int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getGodown(): int
    {
        return $this->godown;
    }

    public function setGodown(int $value): static
    {
        $this->godown = $value;
        return $this;
    }

    public function getRid(): int
    {
        return $this->rid;
    }

    public function setRid(int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getBatchNo(): int
    {
        return $this->batchNo;
    }

    public function setBatchNo(int $value): static
    {
        $this->batchNo = $value;
        return $this;
    }

    public function getCount(): int
    {
        return $this->count;
    }

    public function setCount(int $value): static
    {
        $this->count = $value;
        return $this;
    }

    public function getTwist(): int
    {
        return $this->twist;
    }

    public function setTwist(int $value): static
    {
        $this->twist = $value;
        return $this;
    }

    public function getMinTolerance(): int
    {
        return $this->minTolerance;
    }

    public function setMinTolerance(int $value): static
    {
        $this->minTolerance = $value;
        return $this;
    }

    public function getMaxTolerance(): string
    {
        return HtmlDecode($this->maxTolerance);
    }

    public function setMaxTolerance(string $value): static
    {
        $this->maxTolerance = RemoveXss($value);
        return $this;
    }

    public function getDescription(): string
    {
        return HtmlDecode($this->description);
    }

    public function setDescription(string $value): static
    {
        $this->description = RemoveXss($value);
        return $this;
    }

    public function getYesNo(): int
    {
        return $this->yesNo;
    }

    public function setYesNo(int $value): static
    {
        $this->yesNo = $value;
        return $this;
    }

    public function get40(): int
    {
        return $this->40;
    }

    public function set40(int $value): static
    {
        $this->40 = $value;
        return $this;
    }

    public function getShortageDeduction(): float
    {
        return $this->shortageDeduction;
    }

    public function setShortageDeduction(float $value): static
    {
        $this->shortageDeduction = $value;
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getMethod(): string
    {
        return HtmlDecode($this->method);
    }

    public function setMethod(string $value): static
    {
        $this->method = RemoveXss($value);
        return $this;
    }
}
