<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "payment_plan_extra_weaving" table
 */
#[Entity]
#[Table(name: "payment_plan_extra_weaving")]
class PaymentPlanExtraWeaving extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint", nullable: true)]
    private ?int $width;

    #[Column(type: "smallint", nullable: true)]
    private ?int $0;

    #[Column(type: "smallint", nullable: true)]
    private ?int $1;

    #[Column(type: "smallint", nullable: true)]
    private ?int $2;

    #[Column(type: "smallint", nullable: true)]
    private ?int $3;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    public function __construct()
    {
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getWidth(): ?int
    {
        return $this->width;
    }

    public function setWidth(?int $value): static
    {
        $this->width = $value;
        return $this;
    }

    public function get0(): ?int
    {
        return $this->0;
    }

    public function set0(?int $value): static
    {
        $this->0 = $value;
        return $this;
    }

    public function get1(): ?int
    {
        return $this->1;
    }

    public function set1(?int $value): static
    {
        $this->1 = $value;
        return $this;
    }

    public function get2(): ?int
    {
        return $this->2;
    }

    public function set2(?int $value): static
    {
        $this->2 = $value;
        return $this;
    }

    public function get3(): ?int
    {
        return $this->3;
    }

    public function set3(?int $value): static
    {
        $this->3 = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
