<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "payment_plan_check" table
 */
#[Entity]
#[Table(name: "payment_plan_check")]
class PaymentPlanCheck extends AbstractEntity
{
    #[Column(name: "pa_location", type: "text", nullable: true)]
    private ?string $paLocation;

    #[Column(name: "pa_process", type: "smallint", nullable: true)]
    private ?int $paProcess;

    #[Column(name: "pa_ref", type: "text", nullable: true)]
    private ?string $paRef;

    #[Column(name: "pa_size", type: "text", nullable: true)]
    private ?string $paSize;

    #[Column(type: "string", nullable: true)]
    private ?string $price;

    #[Column(name: "pa_payment", type: "text", nullable: true)]
    private ?string $paPayment;

    #[Column(type: "smallint")]
    private int $pps;

    public function __construct()
    {
        $this->pps = 0;
    }

    public function getPaLocation(): ?string
    {
        return HtmlDecode($this->paLocation);
    }

    public function setPaLocation(?string $value): static
    {
        $this->paLocation = RemoveXss($value);
        return $this;
    }

    public function getPaProcess(): ?int
    {
        return $this->paProcess;
    }

    public function setPaProcess(?int $value): static
    {
        $this->paProcess = $value;
        return $this;
    }

    public function getPaRef(): ?string
    {
        return HtmlDecode($this->paRef);
    }

    public function setPaRef(?string $value): static
    {
        $this->paRef = RemoveXss($value);
        return $this;
    }

    public function getPaSize(): ?string
    {
        return HtmlDecode($this->paSize);
    }

    public function setPaSize(?string $value): static
    {
        $this->paSize = RemoveXss($value);
        return $this;
    }

    public function getPrice(): ?string
    {
        return HtmlDecode($this->price);
    }

    public function setPrice(?string $value): static
    {
        $this->price = RemoveXss($value);
        return $this;
    }

    public function getPaPayment(): ?string
    {
        return HtmlDecode($this->paPayment);
    }

    public function setPaPayment(?string $value): static
    {
        $this->paPayment = RemoveXss($value);
        return $this;
    }

    public function getPps(): int
    {
        return $this->pps;
    }

    public function setPps(int $value): static
    {
        $this->pps = $value;
        return $this;
    }
}
