<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "payment_plan" table
 */
#[Entity]
#[Table(name: "payment_plan")]
class PaymentPlan extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "plan_type", type: "smallint", nullable: true)]
    private ?int $planType;

    #[Column(type: "string", nullable: true)]
    private ?string $location;

    #[Column(name: "from_date", type: "datetime")]
    private DateTime $fromDate;

    #[Column(name: "to_date", type: "datetime")]
    private DateTime $toDate;

    #[Column(type: "integer")]
    private int $grp;

    #[Column(name: "s_grp", type: "smallint", nullable: true)]
    private ?int $sGrp;

    #[Column(type: "smallint", nullable: true)]
    private ?int $process;

    #[Column(name: "product_type", type: "string", nullable: true)]
    private ?string $productType;

    #[Column(type: "string", nullable: true)]
    private ?string $shape;

    #[Column(type: "integer", nullable: true)]
    private ?int $selection;

    #[Column(type: "text", nullable: true)]
    private ?string $gcode;

    #[Column(type: "text", nullable: true)]
    private ?string $ref;

    #[Column(type: "string")]
    private string $description;

    #[Column(name: "yes_no", type: "integer")]
    private int $yesNo;

    #[Column(name: "packing_payment_type", type: "integer", nullable: true)]
    private ?int $packingPaymentType;

    #[Column(type: "integer", nullable: true)]
    private ?int $fix;

    #[Column(type: "string")]
    private string $method;

    #[Column(name: "sqm_method", type: "integer")]
    private int $sqmMethod;

    #[Column(type: "smallint", nullable: true)]
    private ?int $unit;

    #[Column(name: "`@_unit`", options: ["name" => "@_unit"], type: "float", nullable: true)]
    private ?float $unit;

    #[Column(name: "`@`", options: ["name" => "@"], type: "float")]
    private float $40;

    #[Column(name: "extra_plan", type: "smallint")]
    private int $extraPlan;

    #[Column(name: "custom_size", type: "decimal")]
    private string $customSize;

    #[Column(name: "custom_size_below_st", type: "decimal")]
    private string $customSizeBelowSt;

    #[Column(type: "integer")]
    private int $status;

    #[Column(type: "string", nullable: true)]
    private ?string $uploads;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->planType = 1;
        $this->grp = (isset($_GET['GRP']))  ? $_GET['GRP'] : '';
        $this->sGrp = (isset($_GET['SGRP']))  ? $_GET['SGRP'] : '';
        $this->selection = 1;
        $this->gcode = (isset($_GET['GC']))  ? $_GET['GC'] : '';
        $this->ref = (isset($_GET['RID']))  ? $_GET['RID'] : '';
        $this->packingPaymentType = 0;
        $this->fix = 1;
        $this->sqmMethod = 0;
        $this->unit = 5;
        $this->unit = 0;
        $this->40 = 0;
        $this->customSize = "0";
        $this->status = 1;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getPlanType(): ?int
    {
        return $this->planType;
    }

    public function setPlanType(?int $value): static
    {
        $this->planType = $value;
        return $this;
    }

    public function getLocation(): ?string
    {
        return HtmlDecode($this->location);
    }

    public function setLocation(?string $value): static
    {
        $this->location = RemoveXss($value);
        return $this;
    }

    public function getFromDate(): DateTime
    {
        return $this->fromDate;
    }

    public function setFromDate(DateTime $value): static
    {
        $this->fromDate = $value;
        return $this;
    }

    public function getToDate(): DateTime
    {
        return $this->toDate;
    }

    public function setToDate(DateTime $value): static
    {
        $this->toDate = $value;
        return $this;
    }

    public function getGrp(): int
    {
        return $this->grp;
    }

    public function setGrp(int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): ?int
    {
        return $this->sGrp;
    }

    public function setSGrp(?int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getProcess(): ?int
    {
        return $this->process;
    }

    public function setProcess(?int $value): static
    {
        $this->process = $value;
        return $this;
    }

    public function getProductType(): ?string
    {
        return HtmlDecode($this->productType);
    }

    public function setProductType(?string $value): static
    {
        $this->productType = RemoveXss($value);
        return $this;
    }

    public function getShape(): ?string
    {
        return HtmlDecode($this->shape);
    }

    public function setShape(?string $value): static
    {
        $this->shape = RemoveXss($value);
        return $this;
    }

    public function getSelection(): ?int
    {
        return $this->selection;
    }

    public function setSelection(?int $value): static
    {
        $this->selection = $value;
        return $this;
    }

    public function getGcode(): ?string
    {
        return HtmlDecode($this->gcode);
    }

    public function setGcode(?string $value): static
    {
        $this->gcode = RemoveXss($value);
        return $this;
    }

    public function getRef(): ?string
    {
        return HtmlDecode($this->ref);
    }

    public function setRef(?string $value): static
    {
        $this->ref = RemoveXss($value);
        return $this;
    }

    public function getDescription(): string
    {
        return HtmlDecode($this->description);
    }

    public function setDescription(string $value): static
    {
        $this->description = RemoveXss($value);
        return $this;
    }

    public function getYesNo(): int
    {
        return $this->yesNo;
    }

    public function setYesNo(int $value): static
    {
        $this->yesNo = $value;
        return $this;
    }

    public function getPackingPaymentType(): ?int
    {
        return $this->packingPaymentType;
    }

    public function setPackingPaymentType(?int $value): static
    {
        $this->packingPaymentType = $value;
        return $this;
    }

    public function getFix(): ?int
    {
        return $this->fix;
    }

    public function setFix(?int $value): static
    {
        $this->fix = $value;
        return $this;
    }

    public function getMethod(): string
    {
        return HtmlDecode($this->method);
    }

    public function setMethod(string $value): static
    {
        $this->method = RemoveXss($value);
        return $this;
    }

    public function getSqmMethod(): int
    {
        return $this->sqmMethod;
    }

    public function setSqmMethod(int $value): static
    {
        $this->sqmMethod = $value;
        return $this;
    }

    public function getUnit(): ?int
    {
        return $this->unit;
    }

    public function setUnit(?int $value): static
    {
        $this->unit = $value;
        return $this;
    }

    public function getUnit(): ?float
    {
        return $this->unit;
    }

    public function setUnit(?float $value): static
    {
        $this->unit = $value;
        return $this;
    }

    public function get40(): float
    {
        return $this->40;
    }

    public function set40(float $value): static
    {
        $this->40 = $value;
        return $this;
    }

    public function getExtraPlan(): int
    {
        return $this->extraPlan;
    }

    public function setExtraPlan(int $value): static
    {
        $this->extraPlan = $value;
        return $this;
    }

    public function getCustomSize(): string
    {
        return $this->customSize;
    }

    public function setCustomSize(string $value): static
    {
        $this->customSize = $value;
        return $this;
    }

    public function getCustomSizeBelowSt(): string
    {
        return $this->customSizeBelowSt;
    }

    public function setCustomSizeBelowSt(string $value): static
    {
        $this->customSizeBelowSt = $value;
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getUploads(): ?string
    {
        return HtmlDecode($this->uploads);
    }

    public function setUploads(?string $value): static
    {
        $this->uploads = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
