<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "payment_period_f" table
 */
#[Entity]
#[Table(name: "payment_period_f")]
class PaymentPeriodF extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint")]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "integer")]
    private int $grp;

    #[Column(name: "from_date", type: "datetime")]
    private DateTime $fromDate;

    #[Column(name: "to_date", type: "datetime")]
    private DateTime $toDate;

    #[Column(name: "payment_description", type: "string", nullable: true)]
    private ?string $paymentDescription;

    #[Column(type: "string")]
    private string $process;

    public function __construct()
    {
        $this->grp = 1;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getGrp(): int
    {
        return $this->grp;
    }

    public function setGrp(int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getFromDate(): DateTime
    {
        return $this->fromDate;
    }

    public function setFromDate(DateTime $value): static
    {
        $this->fromDate = $value;
        return $this;
    }

    public function getToDate(): DateTime
    {
        return $this->toDate;
    }

    public function setToDate(DateTime $value): static
    {
        $this->toDate = $value;
        return $this;
    }

    public function getPaymentDescription(): ?string
    {
        return HtmlDecode($this->paymentDescription);
    }

    public function setPaymentDescription(?string $value): static
    {
        $this->paymentDescription = RemoveXss($value);
        return $this;
    }

    public function getProcess(): string
    {
        return HtmlDecode($this->process);
    }

    public function setProcess(string $value): static
    {
        $this->process = RemoveXss($value);
        return $this;
    }
}
