<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "payment_period" table
 */
#[Entity]
#[Table(name: "payment_period")]
class PaymentPeriod extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string")]
    private string $location;

    #[Column(type: "integer")]
    private int $grp;

    #[Column(name: "from_date", type: "datetime")]
    private DateTime $fromDate;

    #[Column(name: "to_date", type: "datetime")]
    private DateTime $toDate;

    #[Column(name: "payment_description", type: "string", unique: true, nullable: true)]
    private ?string $paymentDescription;

    #[Column(type: "string")]
    private string $process;

    #[Column(name: "transfer_account", type: "integer")]
    private int $transferAccount;

    #[Column(name: "transfer_by", type: "smallint", nullable: true)]
    private ?int $transferBy;

    #[Column(name: "transfer_datetime", type: "datetime", nullable: true)]
    private ?DateTime $transferDatetime;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    public function __construct()
    {
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getLocation(): string
    {
        return HtmlDecode($this->location);
    }

    public function setLocation(string $value): static
    {
        $this->location = RemoveXss($value);
        return $this;
    }

    public function getGrp(): int
    {
        return $this->grp;
    }

    public function setGrp(int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getFromDate(): DateTime
    {
        return $this->fromDate;
    }

    public function setFromDate(DateTime $value): static
    {
        $this->fromDate = $value;
        return $this;
    }

    public function getToDate(): DateTime
    {
        return $this->toDate;
    }

    public function setToDate(DateTime $value): static
    {
        $this->toDate = $value;
        return $this;
    }

    public function getPaymentDescription(): ?string
    {
        return HtmlDecode($this->paymentDescription);
    }

    public function setPaymentDescription(?string $value): static
    {
        $this->paymentDescription = RemoveXss($value);
        return $this;
    }

    public function getProcess(): string
    {
        return HtmlDecode($this->process);
    }

    public function setProcess(string $value): static
    {
        $this->process = RemoveXss($value);
        return $this;
    }

    public function getTransferAccount(): int
    {
        return $this->transferAccount;
    }

    public function setTransferAccount(int $value): static
    {
        $this->transferAccount = $value;
        return $this;
    }

    public function getTransferBy(): ?int
    {
        return $this->transferBy;
    }

    public function setTransferBy(?int $value): static
    {
        $this->transferBy = $value;
        return $this;
    }

    public function getTransferDatetime(): ?DateTime
    {
        return $this->transferDatetime;
    }

    public function setTransferDatetime(?DateTime $value): static
    {
        $this->transferDatetime = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
