<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "payment_hs" table
 */
#[Entity]
#[Table(name: "payment_hs")]
class PaymentH extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $godown;

    #[Column(name: "emp_id", type: "smallint")]
    private int $empId;

    #[Column(type: "string")]
    private string $ref;

    #[Column(type: "decimal")]
    private string $amount;

    #[Column(type: "string")]
    private string $remarks;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(name: "total_amount", type: "float")]
    private float $totalAmount;

    #[Column(type: "float")]
    private float $balance;

    public function __construct()
    {
        $this->godown = (isset($_COOKIE["User_Site"]))? $_COOKIE["User_Site"]:"";
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getGodown(): int
    {
        return $this->godown;
    }

    public function setGodown(int $value): static
    {
        $this->godown = $value;
        return $this;
    }

    public function getEmpId(): int
    {
        return $this->empId;
    }

    public function setEmpId(int $value): static
    {
        $this->empId = $value;
        return $this;
    }

    public function getRef(): string
    {
        return HtmlDecode($this->ref);
    }

    public function setRef(string $value): static
    {
        $this->ref = RemoveXss($value);
        return $this;
    }

    public function getAmount(): string
    {
        return $this->amount;
    }

    public function setAmount(string $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getRemarks(): string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getTotalAmount(): float
    {
        return $this->totalAmount;
    }

    public function setTotalAmount(float $value): static
    {
        $this->totalAmount = $value;
        return $this;
    }

    public function getBalance(): float
    {
        return $this->balance;
    }

    public function setBalance(float $value): static
    {
        $this->balance = $value;
        return $this;
    }
}
