<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "payment_emp_grp_check" table
 */
#[Entity]
#[Table(name: "payment_emp_grp_check")]
class PaymentEmpGrpCheck extends AbstractEntity
{
    #[Column(type: "bigint")]
    private string $code;

    #[Column(type: "smallint", nullable: true)]
    private ?int $process;

    #[Column(name: "payment_type", type: "integer")]
    private int $paymentType;

    #[Column(type: "string", nullable: true)]
    private ?string $payment;

    #[Column(name: "emp_grp", type: "bigint")]
    private string $empGrp;

    #[Column(type: "bigint")]
    private string $count;

    public function __construct()
    {
        $this->empGrp = "0";
        $this->count = "0";
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function setCode(string $value): static
    {
        $this->code = $value;
        return $this;
    }

    public function getProcess(): ?int
    {
        return $this->process;
    }

    public function setProcess(?int $value): static
    {
        $this->process = $value;
        return $this;
    }

    public function getPaymentType(): int
    {
        return $this->paymentType;
    }

    public function setPaymentType(int $value): static
    {
        $this->paymentType = $value;
        return $this;
    }

    public function getPayment(): ?string
    {
        return HtmlDecode($this->payment);
    }

    public function setPayment(?string $value): static
    {
        $this->payment = RemoveXss($value);
        return $this;
    }

    public function getEmpGrp(): string
    {
        return $this->empGrp;
    }

    public function setEmpGrp(string $value): static
    {
        $this->empGrp = $value;
        return $this;
    }

    public function getCount(): string
    {
        return $this->count;
    }

    public function setCount(string $value): static
    {
        $this->count = $value;
        return $this;
    }
}
