<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "password_reset_temp" table
 */
#[Entity]
#[Table(name: "password_reset_temp")]
class PasswordResetTemp extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "login_id", type: "smallint")]
    private int $loginId;

    #[Column(type: "string")]
    private string $email;

    #[Column(name: "`key`", options: ["name" => "key"], type: "string")]
    private string $key;

    #[Column(type: "datetime")]
    private DateTime $expDate;

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getLoginId(): int
    {
        return $this->loginId;
    }

    public function setLoginId(int $value): static
    {
        $this->loginId = $value;
        return $this;
    }

    public function getEmail(): string
    {
        return HtmlDecode($this->email);
    }

    public function setEmail(string $value): static
    {
        $this->email = RemoveXss($value);
        return $this;
    }

    public function getKey(): string
    {
        return HtmlDecode($this->key);
    }

    public function setKey(string $value): static
    {
        $this->key = RemoveXss($value);
        return $this;
    }

    public function getExpDate(): DateTime
    {
        return $this->expDate;
    }

    public function setExpDate(DateTime $value): static
    {
        $this->expDate = $value;
        return $this;
    }
}
