<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "partner_quotation_buyer" table
 */
#[Entity]
#[Table(name: "partner_quotation_buyer")]
class PartnerQuotationBuyer extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "company_id", type: "text", nullable: true)]
    private ?string $companyId;

    #[Column(name: "partner_id", type: "integer", nullable: true)]
    private ?int $partnerId;

    #[Column(name: "partner_details", type: "string", nullable: true)]
    private ?string $partnerDetails;

    #[Column(name: "product_type", type: "smallint", nullable: true)]
    private ?int $productType;

    #[Column(type: "smallint", nullable: true)]
    private ?int $product;

    #[Column(name: "product_code", type: "smallint", nullable: true)]
    private ?int $productCode;

    #[Column(name: "partner_code", type: "string", nullable: true)]
    private ?string $partnerCode;

    #[Column(name: "packing_type", type: "smallint", nullable: true)]
    private ?int $packingType;

    #[Column(type: "smallint", nullable: true)]
    private ?int $unit;

    #[Column(name: "quantity_approx", type: "string", nullable: true)]
    private ?string $quantityApprox;

    #[Column(type: "decimal", nullable: true)]
    private ?string $quantity;

    #[Column(type: "decimal", nullable: true)]
    private ?string $price;

    #[Column(type: "decimal", nullable: true)]
    private ?string $amount;

    #[Column(type: "smallint", nullable: true)]
    private ?int $currency;

    #[Column(name: "total_amount", type: "decimal", nullable: true)]
    private ?string $totalAmount;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(name: "payment_terms", type: "smallint", nullable: true)]
    private ?int $paymentTerms;

    #[Column(name: "tax_categories", type: "smallint", nullable: true)]
    private ?int $taxCategories;

    #[Column(name: "delivery_period", type: "smallint", nullable: true)]
    private ?int $deliveryPeriod;

    #[Column(type: "integer", nullable: true)]
    private ?int $status;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(name: "pp_operator", type: "smallint", nullable: true)]
    private ?int $ppOperator;

    #[Column(name: "pp_datetime", type: "datetime", nullable: true)]
    private ?DateTime $ppDatetime;

    public function __construct()
    {
        $this->deliveryPeriod = 0;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getCompanyId(): ?string
    {
        return HtmlDecode($this->companyId);
    }

    public function setCompanyId(?string $value): static
    {
        $this->companyId = RemoveXss($value);
        return $this;
    }

    public function getPartnerId(): ?int
    {
        return $this->partnerId;
    }

    public function setPartnerId(?int $value): static
    {
        $this->partnerId = $value;
        return $this;
    }

    public function getPartnerDetails(): ?string
    {
        return HtmlDecode($this->partnerDetails);
    }

    public function setPartnerDetails(?string $value): static
    {
        $this->partnerDetails = RemoveXss($value);
        return $this;
    }

    public function getProductType(): ?int
    {
        return $this->productType;
    }

    public function setProductType(?int $value): static
    {
        $this->productType = $value;
        return $this;
    }

    public function getProduct(): ?int
    {
        return $this->product;
    }

    public function setProduct(?int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getProductCode(): ?int
    {
        return $this->productCode;
    }

    public function setProductCode(?int $value): static
    {
        $this->productCode = $value;
        return $this;
    }

    public function getPartnerCode(): ?string
    {
        return HtmlDecode($this->partnerCode);
    }

    public function setPartnerCode(?string $value): static
    {
        $this->partnerCode = RemoveXss($value);
        return $this;
    }

    public function getPackingType(): ?int
    {
        return $this->packingType;
    }

    public function setPackingType(?int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getUnit(): ?int
    {
        return $this->unit;
    }

    public function setUnit(?int $value): static
    {
        $this->unit = $value;
        return $this;
    }

    public function getQuantityApprox(): ?string
    {
        return HtmlDecode($this->quantityApprox);
    }

    public function setQuantityApprox(?string $value): static
    {
        $this->quantityApprox = RemoveXss($value);
        return $this;
    }

    public function getQuantity(): ?string
    {
        return $this->quantity;
    }

    public function setQuantity(?string $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getPrice(): ?string
    {
        return $this->price;
    }

    public function setPrice(?string $value): static
    {
        $this->price = $value;
        return $this;
    }

    public function getAmount(): ?string
    {
        return $this->amount;
    }

    public function setAmount(?string $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getCurrency(): ?int
    {
        return $this->currency;
    }

    public function setCurrency(?int $value): static
    {
        $this->currency = $value;
        return $this;
    }

    public function getTotalAmount(): ?string
    {
        return $this->totalAmount;
    }

    public function setTotalAmount(?string $value): static
    {
        $this->totalAmount = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getPaymentTerms(): ?int
    {
        return $this->paymentTerms;
    }

    public function setPaymentTerms(?int $value): static
    {
        $this->paymentTerms = $value;
        return $this;
    }

    public function getTaxCategories(): ?int
    {
        return $this->taxCategories;
    }

    public function setTaxCategories(?int $value): static
    {
        $this->taxCategories = $value;
        return $this;
    }

    public function getDeliveryPeriod(): ?int
    {
        return $this->deliveryPeriod;
    }

    public function setDeliveryPeriod(?int $value): static
    {
        $this->deliveryPeriod = $value;
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getPpOperator(): ?int
    {
        return $this->ppOperator;
    }

    public function setPpOperator(?int $value): static
    {
        $this->ppOperator = $value;
        return $this;
    }

    public function getPpDatetime(): ?DateTime
    {
        return $this->ppDatetime;
    }

    public function setPpDatetime(?DateTime $value): static
    {
        $this->ppDatetime = $value;
        return $this;
    }
}
