<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "partner_product_ref" table
 */
#[Entity]
#[Table(name: "partner_product_ref")]
class PartnerProductRef extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "partner_type", type: "integer")]
    private int $partnerType;

    #[Column(type: "integer")]
    private int $partner;

    #[Column(name: "partner_ref", type: "string")]
    private string $partnerRef;

    #[Column(type: "string", nullable: true)]
    private ?string $barcode;

    #[Column(name: "partner_code", type: "string", nullable: true)]
    private ?string $partnerCode;

    #[Column(name: "product_type", type: "smallint", nullable: true)]
    private ?int $productType;

    #[Column(type: "smallint", nullable: true)]
    private ?int $grp;

    #[Column(name: "s_grp", type: "smallint", nullable: true)]
    private ?int $sGrp;

    #[Column(type: "smallint", nullable: true)]
    private ?int $product;

    #[Column(type: "smallint", nullable: true)]
    private ?int $rid;

    #[Column(name: "spl_ins", type: "string", nullable: true)]
    private ?string $splIns;

    #[Column(name: "packing_type", type: "smallint", nullable: true)]
    private ?int $packingType;

    #[Column(name: "batch_no", type: "smallint", nullable: true)]
    private ?int $batchNo;

    #[Column(type: "string", nullable: true)]
    private ?string $shape;

    #[Column(type: "smallint", nullable: true)]
    private ?int $unit;

    #[Column(type: "string", nullable: true)]
    private ?string $w;

    #[Column(name: "w_cm", type: "integer", nullable: true)]
    private ?int $wCm;

    #[Column(type: "string", nullable: true)]
    private ?string $l;

    #[Column(name: "l_cm", type: "integer", nullable: true)]
    private ?int $lCm;

    #[Column(type: "string", nullable: true)]
    private ?string $h;

    #[Column(name: "h_cm", type: "integer", nullable: true)]
    private ?int $hCm;

    #[Column(name: "partner_size", type: "string", nullable: true)]
    private ?string $partnerSize;

    #[Column(type: "decimal", nullable: true)]
    private ?string $sqm;

    #[Column(type: "decimal")]
    private string $cbm;

    #[Column(name: "weight_sqm", type: "decimal")]
    private string $weightSqm;

    #[Column(name: "sqm_a", type: "decimal", nullable: true)]
    private ?string $sqmA;

    #[Column(name: "`2srm_a`", options: ["name" => "2srm_a"], type: "decimal", nullable: true)]
    private ?string $2srmA;

    #[Column(name: "`4srm_a`", options: ["name" => "4srm_a"], type: "decimal", nullable: true)]
    private ?string $4srmA;

    #[Column(type: "float", nullable: true)]
    private ?float $price;

    #[Column(name: "price_cs", type: "decimal", nullable: true)]
    private ?string $priceCs;

    #[Column(type: "smallint", nullable: true)]
    private ?int $currency;

    #[Column(type: "smallint", nullable: true)]
    private ?int $hsn;

    #[Column(type: "smallint", nullable: true)]
    private ?int $composition;

    #[Column(type: "integer")]
    private int $status;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(type: "string")]
    private string $gcode;

    #[Column(name: "d_01", type: "string", nullable: true)]
    private ?string $d01;

    #[Column(name: "d_02", type: "string", nullable: true)]
    private ?string $d02;

    #[Column(name: "d_03", type: "string", nullable: true)]
    private ?string $d03;

    #[Column(name: "d_04", type: "string", nullable: true)]
    private ?string $d04;

    #[Column(name: "d_05", type: "string", nullable: true)]
    private ?string $d05;

    #[Column(name: "d_06", type: "string", nullable: true)]
    private ?string $d06;

    public function __construct()
    {
        $this->partnerType = User_Category();
        $this->partner = User_Company_ID();
        $this->productType = 0;
        $this->shape = "1";
        $this->unit = 1;
        $this->w = "00";
        $this->l = "00";
        $this->h = "00";
        $this->cbm = "0.0000";
        $this->price = 0;
        $this->currency = 1;
        $this->status = 1;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getPartnerType(): int
    {
        return $this->partnerType;
    }

    public function setPartnerType(int $value): static
    {
        $this->partnerType = $value;
        return $this;
    }

    public function getPartner(): int
    {
        return $this->partner;
    }

    public function setPartner(int $value): static
    {
        $this->partner = $value;
        return $this;
    }

    public function getPartnerRef(): string
    {
        return HtmlDecode($this->partnerRef);
    }

    public function setPartnerRef(string $value): static
    {
        $this->partnerRef = RemoveXss($value);
        return $this;
    }

    public function getBarcode(): ?string
    {
        return HtmlDecode($this->barcode);
    }

    public function setBarcode(?string $value): static
    {
        $this->barcode = RemoveXss($value);
        return $this;
    }

    public function getPartnerCode(): ?string
    {
        return HtmlDecode($this->partnerCode);
    }

    public function setPartnerCode(?string $value): static
    {
        $this->partnerCode = RemoveXss($value);
        return $this;
    }

    public function getProductType(): ?int
    {
        return $this->productType;
    }

    public function setProductType(?int $value): static
    {
        $this->productType = $value;
        return $this;
    }

    public function getGrp(): ?int
    {
        return $this->grp;
    }

    public function setGrp(?int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): ?int
    {
        return $this->sGrp;
    }

    public function setSGrp(?int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getProduct(): ?int
    {
        return $this->product;
    }

    public function setProduct(?int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getRid(): ?int
    {
        return $this->rid;
    }

    public function setRid(?int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getSplIns(): ?string
    {
        return HtmlDecode($this->splIns);
    }

    public function setSplIns(?string $value): static
    {
        $this->splIns = RemoveXss($value);
        return $this;
    }

    public function getPackingType(): ?int
    {
        return $this->packingType;
    }

    public function setPackingType(?int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getBatchNo(): ?int
    {
        return $this->batchNo;
    }

    public function setBatchNo(?int $value): static
    {
        $this->batchNo = $value;
        return $this;
    }

    public function getShape(): ?string
    {
        return HtmlDecode($this->shape);
    }

    public function setShape(?string $value): static
    {
        $this->shape = RemoveXss($value);
        return $this;
    }

    public function getUnit(): ?int
    {
        return $this->unit;
    }

    public function setUnit(?int $value): static
    {
        $this->unit = $value;
        return $this;
    }

    public function getW(): ?string
    {
        return HtmlDecode($this->w);
    }

    public function setW(?string $value): static
    {
        $this->w = RemoveXss($value);
        return $this;
    }

    public function getWCm(): ?int
    {
        return $this->wCm;
    }

    public function setWCm(?int $value): static
    {
        $this->wCm = $value;
        return $this;
    }

    public function getL(): ?string
    {
        return HtmlDecode($this->l);
    }

    public function setL(?string $value): static
    {
        $this->l = RemoveXss($value);
        return $this;
    }

    public function getLCm(): ?int
    {
        return $this->lCm;
    }

    public function setLCm(?int $value): static
    {
        $this->lCm = $value;
        return $this;
    }

    public function getH(): ?string
    {
        return HtmlDecode($this->h);
    }

    public function setH(?string $value): static
    {
        $this->h = RemoveXss($value);
        return $this;
    }

    public function getHCm(): ?int
    {
        return $this->hCm;
    }

    public function setHCm(?int $value): static
    {
        $this->hCm = $value;
        return $this;
    }

    public function getPartnerSize(): ?string
    {
        return HtmlDecode($this->partnerSize);
    }

    public function setPartnerSize(?string $value): static
    {
        $this->partnerSize = RemoveXss($value);
        return $this;
    }

    public function getSqm(): ?string
    {
        return $this->sqm;
    }

    public function setSqm(?string $value): static
    {
        $this->sqm = $value;
        return $this;
    }

    public function getCbm(): string
    {
        return $this->cbm;
    }

    public function setCbm(string $value): static
    {
        $this->cbm = $value;
        return $this;
    }

    public function getWeightSqm(): string
    {
        return $this->weightSqm;
    }

    public function setWeightSqm(string $value): static
    {
        $this->weightSqm = $value;
        return $this;
    }

    public function getSqmA(): ?string
    {
        return $this->sqmA;
    }

    public function setSqmA(?string $value): static
    {
        $this->sqmA = $value;
        return $this;
    }

    public function get2srmA(): ?string
    {
        return $this->2srmA;
    }

    public function set2srmA(?string $value): static
    {
        $this->2srmA = $value;
        return $this;
    }

    public function get4srmA(): ?string
    {
        return $this->4srmA;
    }

    public function set4srmA(?string $value): static
    {
        $this->4srmA = $value;
        return $this;
    }

    public function getPrice(): ?float
    {
        return $this->price;
    }

    public function setPrice(?float $value): static
    {
        $this->price = $value;
        return $this;
    }

    public function getPriceCs(): ?string
    {
        return $this->priceCs;
    }

    public function setPriceCs(?string $value): static
    {
        $this->priceCs = $value;
        return $this;
    }

    public function getCurrency(): ?int
    {
        return $this->currency;
    }

    public function setCurrency(?int $value): static
    {
        $this->currency = $value;
        return $this;
    }

    public function getHsn(): ?int
    {
        return $this->hsn;
    }

    public function setHsn(?int $value): static
    {
        $this->hsn = $value;
        return $this;
    }

    public function getComposition(): ?int
    {
        return $this->composition;
    }

    public function setComposition(?int $value): static
    {
        $this->composition = $value;
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getGcode(): string
    {
        return HtmlDecode($this->gcode);
    }

    public function setGcode(string $value): static
    {
        $this->gcode = RemoveXss($value);
        return $this;
    }

    public function getD01(): ?string
    {
        return HtmlDecode($this->d01);
    }

    public function setD01(?string $value): static
    {
        $this->d01 = RemoveXss($value);
        return $this;
    }

    public function getD02(): ?string
    {
        return HtmlDecode($this->d02);
    }

    public function setD02(?string $value): static
    {
        $this->d02 = RemoveXss($value);
        return $this;
    }

    public function getD03(): ?string
    {
        return HtmlDecode($this->d03);
    }

    public function setD03(?string $value): static
    {
        $this->d03 = RemoveXss($value);
        return $this;
    }

    public function getD04(): ?string
    {
        return HtmlDecode($this->d04);
    }

    public function setD04(?string $value): static
    {
        $this->d04 = RemoveXss($value);
        return $this;
    }

    public function getD05(): ?string
    {
        return HtmlDecode($this->d05);
    }

    public function setD05(?string $value): static
    {
        $this->d05 = RemoveXss($value);
        return $this;
    }

    public function getD06(): ?string
    {
        return HtmlDecode($this->d06);
    }

    public function setD06(?string $value): static
    {
        $this->d06 = RemoveXss($value);
        return $this;
    }
}
