<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "partner_balance" table
 */
#[Entity]
#[Table(name: "partner_balance")]
class PartnerBalance extends AbstractEntity
{
    #[Column(type: "integer", nullable: true)]
    private ?int $location;

    #[Column(name: "partner_id", type: "integer", nullable: true)]
    private ?int $partnerId;

    #[Column(type: "bigint", nullable: true)]
    private ?string $balance;

    #[Column(type: "bigint", nullable: true)]
    private ?string $receipt;

    #[Column(name: "panel_amount", type: "bigint", nullable: true)]
    private ?string $panelAmount;

    #[Column(name: "total_amount", type: "bigint", nullable: true)]
    private ?string $totalAmount;

    #[Column(type: "string", nullable: true)]
    private ?string $ref;

    #[Column(name: "partner_name", type: "string", nullable: true)]
    private ?string $partnerName;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $dated;

    public function __construct()
    {
        $this->location = 0;
        $this->receipt = "0.00";
    }

    public function getLocation(): ?int
    {
        return $this->location;
    }

    public function setLocation(?int $value): static
    {
        $this->location = $value;
        return $this;
    }

    public function getPartnerId(): ?int
    {
        return $this->partnerId;
    }

    public function setPartnerId(?int $value): static
    {
        $this->partnerId = $value;
        return $this;
    }

    public function getBalance(): ?string
    {
        return $this->balance;
    }

    public function setBalance(?string $value): static
    {
        $this->balance = $value;
        return $this;
    }

    public function getReceipt(): ?string
    {
        return $this->receipt;
    }

    public function setReceipt(?string $value): static
    {
        $this->receipt = $value;
        return $this;
    }

    public function getPanelAmount(): ?string
    {
        return $this->panelAmount;
    }

    public function setPanelAmount(?string $value): static
    {
        $this->panelAmount = $value;
        return $this;
    }

    public function getTotalAmount(): ?string
    {
        return $this->totalAmount;
    }

    public function setTotalAmount(?string $value): static
    {
        $this->totalAmount = $value;
        return $this;
    }

    public function getRef(): ?string
    {
        return HtmlDecode($this->ref);
    }

    public function setRef(?string $value): static
    {
        $this->ref = RemoveXss($value);
        return $this;
    }

    public function getPartnerName(): ?string
    {
        return HtmlDecode($this->partnerName);
    }

    public function setPartnerName(?string $value): static
    {
        $this->partnerName = RemoveXss($value);
        return $this;
    }

    public function getDated(): ?DateTime
    {
        return $this->dated;
    }

    public function setDated(?DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }
}
