<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "packing_type_table" table
 */
#[Entity]
#[Table(name: "packing_type_table")]
class PackingTypeTable extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string")]
    private string $grp;

    #[Column(type: "string")]
    private string $packing;

    #[Column(type: "string")]
    private string $code;

    #[Column(type: "integer")]
    private int $ply;

    #[Column(name: "rid_new", type: "integer")]
    private int $ridNew;

    #[Column(name: "internal_external", type: "integer")]
    private int $internalExternal;

    #[Column(type: "string", nullable: true)]
    private ?string $process;

    #[Column(type: "integer")]
    private int $status;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(type: "smallint")]
    private int $product;

    #[Column(name: "UID", type: "string", unique: true, nullable: true)]
    private ?string $uid;

    public function __construct()
    {
        $this->ply = 0;
        $this->ridNew = 0;
        $this->internalExternal = 0;
        $this->status = 1;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getGrp(): string
    {
        return HtmlDecode($this->grp);
    }

    public function setGrp(string $value): static
    {
        $this->grp = RemoveXss($value);
        return $this;
    }

    public function getPacking(): string
    {
        return HtmlDecode($this->packing);
    }

    public function setPacking(string $value): static
    {
        $this->packing = RemoveXss($value);
        return $this;
    }

    public function getCode(): string
    {
        return HtmlDecode($this->code);
    }

    public function setCode(string $value): static
    {
        $this->code = RemoveXss($value);
        return $this;
    }

    public function getPly(): int
    {
        return $this->ply;
    }

    public function setPly(int $value): static
    {
        $this->ply = $value;
        return $this;
    }

    public function getRidNew(): int
    {
        return $this->ridNew;
    }

    public function setRidNew(int $value): static
    {
        $this->ridNew = $value;
        return $this;
    }

    public function getInternalExternal(): int
    {
        return $this->internalExternal;
    }

    public function setInternalExternal(int $value): static
    {
        $this->internalExternal = $value;
        return $this;
    }

    public function getProcess(): ?string
    {
        return HtmlDecode($this->process);
    }

    public function setProcess(?string $value): static
    {
        $this->process = RemoveXss($value);
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getProduct(): int
    {
        return $this->product;
    }

    public function setProduct(int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getUid(): ?string
    {
        return HtmlDecode($this->uid);
    }

    public function setUid(?string $value): static
    {
        $this->uid = RemoveXss($value);
        return $this;
    }
}
