<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "packing_type" table
 */
#[Entity]
#[Table(name: "packing_type")]
class PackingType extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint")]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint", nullable: true)]
    #[GeneratedValue]
    private ?int $grp;

    #[Column(type: "smallint")]
    private int $product;

    #[Column(type: "string")]
    private string $packing;

    #[Column(type: "string")]
    private string $code;

    #[Column(type: "string", nullable: true)]
    private ?string $process;

    #[Column(name: "internal_external", type: "integer")]
    private int $internalExternal;

    #[Column(type: "integer")]
    private int $status;

    public function __construct()
    {
        $this->internalExternal = 0;
        $this->status = 1;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getGrp(): ?int
    {
        return $this->grp;
    }

    public function setGrp(?int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getProduct(): int
    {
        return $this->product;
    }

    public function setProduct(int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getPacking(): string
    {
        return HtmlDecode($this->packing);
    }

    public function setPacking(string $value): static
    {
        $this->packing = RemoveXss($value);
        return $this;
    }

    public function getCode(): string
    {
        return HtmlDecode($this->code);
    }

    public function setCode(string $value): static
    {
        $this->code = RemoveXss($value);
        return $this;
    }

    public function getProcess(): ?string
    {
        return HtmlDecode($this->process);
    }

    public function setProcess(?string $value): static
    {
        $this->process = RemoveXss($value);
        return $this;
    }

    public function getInternalExternal(): int
    {
        return $this->internalExternal;
    }

    public function setInternalExternal(int $value): static
    {
        $this->internalExternal = $value;
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }
}
