<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "packing_list_no" table
 */
#[Entity]
#[Table(name: "packing_list_no")]
class PackingListNo extends AbstractEntity
{
    #[Column(name: "buyer_po", type: "string", nullable: true)]
    private ?string $buyerPo;

    #[Column(name: "roll_no", type: "smallint", nullable: true)]
    private ?int $rollNo;

    #[Column(type: "smallint", nullable: true)]
    private ?int $qty;

    #[Column(name: "pl_no", type: "decimal")]
    private string $plNo;

    #[Column(type: "integer")]
    private int $barcode;

    #[Column(name: "buyer_ref", type: "smallint", nullable: true)]
    private ?int $buyerRef;

    #[Column(name: "design_id", type: "string", nullable: true)]
    private ?string $designId;

    #[Column(name: "size_buyer", type: "string", nullable: true)]
    private ?string $sizeBuyer;

    #[Column(name: "buyers_id", type: "integer", nullable: true)]
    private ?int $buyersId;

    #[Column(type: "integer", nullable: true)]
    private ?int $po;

    #[Column(name: "despatch_week", type: "smallint", nullable: true)]
    private ?int $despatchWeek;

    #[Column(type: "float", nullable: true)]
    private ?float $sqm;

    #[Column(name: "sqm_a", type: "float", nullable: true)]
    private ?float $sqmA;

    #[Column(name: "current_works", type: "smallint")]
    private int $currentWorks;

    #[Id]
    #[Column(type: "integer")]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(name: "po_price", type: "string", nullable: true)]
    private ?string $poPrice;

    #[Column(name: "po_discount", type: "decimal")]
    private string $poDiscount;

    #[Column(name: "po_currency", type: "smallint", nullable: true)]
    private ?int $poCurrency;

    #[Column(name: "buyer_uid", type: "string", nullable: true)]
    private ?string $buyerUid;

    #[Column(name: "buyer_loc", type: "string")]
    private string $buyerLoc;

    public function __construct()
    {
        $this->plNo = "0.00";
        $this->barcode = 0;
        $this->currentWorks = 0;
        $this->operator = 0;
        $this->poDiscount = "0.00";
        $this->buyerLoc = "0";
    }

    public function getBuyerPo(): ?string
    {
        return HtmlDecode($this->buyerPo);
    }

    public function setBuyerPo(?string $value): static
    {
        $this->buyerPo = RemoveXss($value);
        return $this;
    }

    public function getRollNo(): ?int
    {
        return $this->rollNo;
    }

    public function setRollNo(?int $value): static
    {
        $this->rollNo = $value;
        return $this;
    }

    public function getQty(): ?int
    {
        return $this->qty;
    }

    public function setQty(?int $value): static
    {
        $this->qty = $value;
        return $this;
    }

    public function getPlNo(): string
    {
        return $this->plNo;
    }

    public function setPlNo(string $value): static
    {
        $this->plNo = $value;
        return $this;
    }

    public function getBarcode(): int
    {
        return $this->barcode;
    }

    public function setBarcode(int $value): static
    {
        $this->barcode = $value;
        return $this;
    }

    public function getBuyerRef(): ?int
    {
        return $this->buyerRef;
    }

    public function setBuyerRef(?int $value): static
    {
        $this->buyerRef = $value;
        return $this;
    }

    public function getDesignId(): ?string
    {
        return HtmlDecode($this->designId);
    }

    public function setDesignId(?string $value): static
    {
        $this->designId = RemoveXss($value);
        return $this;
    }

    public function getSizeBuyer(): ?string
    {
        return HtmlDecode($this->sizeBuyer);
    }

    public function setSizeBuyer(?string $value): static
    {
        $this->sizeBuyer = RemoveXss($value);
        return $this;
    }

    public function getBuyersId(): ?int
    {
        return $this->buyersId;
    }

    public function setBuyersId(?int $value): static
    {
        $this->buyersId = $value;
        return $this;
    }

    public function getPo(): ?int
    {
        return $this->po;
    }

    public function setPo(?int $value): static
    {
        $this->po = $value;
        return $this;
    }

    public function getDespatchWeek(): ?int
    {
        return $this->despatchWeek;
    }

    public function setDespatchWeek(?int $value): static
    {
        $this->despatchWeek = $value;
        return $this;
    }

    public function getSqm(): ?float
    {
        return $this->sqm;
    }

    public function setSqm(?float $value): static
    {
        $this->sqm = $value;
        return $this;
    }

    public function getSqmA(): ?float
    {
        return $this->sqmA;
    }

    public function setSqmA(?float $value): static
    {
        $this->sqmA = $value;
        return $this;
    }

    public function getCurrentWorks(): int
    {
        return $this->currentWorks;
    }

    public function setCurrentWorks(int $value): static
    {
        $this->currentWorks = $value;
        return $this;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getPoPrice(): ?string
    {
        return HtmlDecode($this->poPrice);
    }

    public function setPoPrice(?string $value): static
    {
        $this->poPrice = RemoveXss($value);
        return $this;
    }

    public function getPoDiscount(): string
    {
        return $this->poDiscount;
    }

    public function setPoDiscount(string $value): static
    {
        $this->poDiscount = $value;
        return $this;
    }

    public function getPoCurrency(): ?int
    {
        return $this->poCurrency;
    }

    public function setPoCurrency(?int $value): static
    {
        $this->poCurrency = $value;
        return $this;
    }

    public function getBuyerUid(): ?string
    {
        return HtmlDecode($this->buyerUid);
    }

    public function setBuyerUid(?string $value): static
    {
        $this->buyerUid = RemoveXss($value);
        return $this;
    }

    public function getBuyerLoc(): string
    {
        return HtmlDecode($this->buyerLoc);
    }

    public function setBuyerLoc(string $value): static
    {
        $this->buyerLoc = RemoveXss($value);
        return $this;
    }
}
