<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "packing_list" table
 */
#[Entity]
#[Table(name: "packing_list")]
class PackingList extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "pl_no", type: "decimal", nullable: true)]
    private ?string $plNo;

    #[Column(name: "buyers_id", type: "smallint", nullable: true)]
    private ?int $buyersId;

    #[Column(type: "text", nullable: true)]
    private ?string $barcode;

    #[Column(name: "roll_no", type: "string", nullable: true)]
    private ?string $rollNo;

    #[Column(name: "no_of_bales", type: "smallint")]
    private int $noOfBales;

    #[Column(type: "text", nullable: true)]
    private ?string $design;

    #[Column(name: "buyer_ref", type: "text", nullable: true)]
    private ?string $buyerRef;

    #[Column(name: "buyer_code", type: "string", nullable: true)]
    private ?string $buyerCode;

    #[Column(name: "buyer_po", type: "string", nullable: true)]
    private ?string $buyerPo;

    #[Column(type: "bigint")]
    private string $quantity;

    #[Column(type: "string", nullable: true)]
    private ?string $size;

    #[Column(type: "decimal")]
    private string $sqm;

    #[Column(name: "sqm_a", type: "decimal", nullable: true)]
    private ?string $sqmA;

    #[Column(type: "decimal")]
    private string $price;

    #[Column(name: "price_a", type: "decimal", nullable: true)]
    private ?string $priceA;

    #[Column(type: "decimal", nullable: true)]
    private ?string $discount;

    #[Column(type: "decimal")]
    private string $amount;

    #[Column(type: "smallint")]
    private int $currency;

    #[Column(type: "string", nullable: true)]
    private ?string $composition;

    #[Column(type: "string", nullable: true)]
    private ?string $hsn;

    #[Column(type: "string", nullable: true)]
    private ?string $gst;

    #[Column(name: "price_exchange", type: "decimal")]
    private string $priceExchange;

    #[Column(name: "price_exchange_a", type: "decimal", nullable: true)]
    private ?string $priceExchangeA;

    #[Column(name: "amount_exchange", type: "decimal")]
    private string $amountExchange;

    #[Column(type: "decimal", nullable: true)]
    private ?string $cbm;

    #[Column(type: "decimal", nullable: true)]
    private ?string $weight;

    #[Column(name: "partner_other_ref", type: "string", nullable: true)]
    private ?string $partnerOtherRef;

    #[Column(name: "roll_no_start", type: "smallint", nullable: true)]
    private ?int $rollNoStart;

    #[Column(name: "roll_no_end", type: "smallint", nullable: true)]
    private ?int $rollNoEnd;

    #[Column(name: "buyer_loc", type: "string", nullable: true)]
    private ?string $buyerLoc;

    #[Column(type: "string", nullable: true)]
    private ?string $po;

    public function __construct()
    {
        $this->noOfBales = 0;
        $this->quantity = "0";
        $this->discount = "0.00";
        $this->priceExchange = "0.0000";
        $this->amountExchange = "0.0000";
        $this->rollNoEnd = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getPlNo(): ?string
    {
        return $this->plNo;
    }

    public function setPlNo(?string $value): static
    {
        $this->plNo = $value;
        return $this;
    }

    public function getBuyersId(): ?int
    {
        return $this->buyersId;
    }

    public function setBuyersId(?int $value): static
    {
        $this->buyersId = $value;
        return $this;
    }

    public function getBarcode(): ?string
    {
        return HtmlDecode($this->barcode);
    }

    public function setBarcode(?string $value): static
    {
        $this->barcode = RemoveXss($value);
        return $this;
    }

    public function getRollNo(): ?string
    {
        return HtmlDecode($this->rollNo);
    }

    public function setRollNo(?string $value): static
    {
        $this->rollNo = RemoveXss($value);
        return $this;
    }

    public function getNoOfBales(): int
    {
        return $this->noOfBales;
    }

    public function setNoOfBales(int $value): static
    {
        $this->noOfBales = $value;
        return $this;
    }

    public function getDesign(): ?string
    {
        return HtmlDecode($this->design);
    }

    public function setDesign(?string $value): static
    {
        $this->design = RemoveXss($value);
        return $this;
    }

    public function getBuyerRef(): ?string
    {
        return HtmlDecode($this->buyerRef);
    }

    public function setBuyerRef(?string $value): static
    {
        $this->buyerRef = RemoveXss($value);
        return $this;
    }

    public function getBuyerCode(): ?string
    {
        return HtmlDecode($this->buyerCode);
    }

    public function setBuyerCode(?string $value): static
    {
        $this->buyerCode = RemoveXss($value);
        return $this;
    }

    public function getBuyerPo(): ?string
    {
        return HtmlDecode($this->buyerPo);
    }

    public function setBuyerPo(?string $value): static
    {
        $this->buyerPo = RemoveXss($value);
        return $this;
    }

    public function getQuantity(): string
    {
        return $this->quantity;
    }

    public function setQuantity(string $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getSize(): ?string
    {
        return HtmlDecode($this->size);
    }

    public function setSize(?string $value): static
    {
        $this->size = RemoveXss($value);
        return $this;
    }

    public function getSqm(): string
    {
        return $this->sqm;
    }

    public function setSqm(string $value): static
    {
        $this->sqm = $value;
        return $this;
    }

    public function getSqmA(): ?string
    {
        return $this->sqmA;
    }

    public function setSqmA(?string $value): static
    {
        $this->sqmA = $value;
        return $this;
    }

    public function getPrice(): string
    {
        return $this->price;
    }

    public function setPrice(string $value): static
    {
        $this->price = $value;
        return $this;
    }

    public function getPriceA(): ?string
    {
        return $this->priceA;
    }

    public function setPriceA(?string $value): static
    {
        $this->priceA = $value;
        return $this;
    }

    public function getDiscount(): ?string
    {
        return $this->discount;
    }

    public function setDiscount(?string $value): static
    {
        $this->discount = $value;
        return $this;
    }

    public function getAmount(): string
    {
        return $this->amount;
    }

    public function setAmount(string $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getCurrency(): int
    {
        return $this->currency;
    }

    public function setCurrency(int $value): static
    {
        $this->currency = $value;
        return $this;
    }

    public function getComposition(): ?string
    {
        return HtmlDecode($this->composition);
    }

    public function setComposition(?string $value): static
    {
        $this->composition = RemoveXss($value);
        return $this;
    }

    public function getHsn(): ?string
    {
        return HtmlDecode($this->hsn);
    }

    public function setHsn(?string $value): static
    {
        $this->hsn = RemoveXss($value);
        return $this;
    }

    public function getGst(): ?string
    {
        return HtmlDecode($this->gst);
    }

    public function setGst(?string $value): static
    {
        $this->gst = RemoveXss($value);
        return $this;
    }

    public function getPriceExchange(): string
    {
        return $this->priceExchange;
    }

    public function setPriceExchange(string $value): static
    {
        $this->priceExchange = $value;
        return $this;
    }

    public function getPriceExchangeA(): ?string
    {
        return $this->priceExchangeA;
    }

    public function setPriceExchangeA(?string $value): static
    {
        $this->priceExchangeA = $value;
        return $this;
    }

    public function getAmountExchange(): string
    {
        return $this->amountExchange;
    }

    public function setAmountExchange(string $value): static
    {
        $this->amountExchange = $value;
        return $this;
    }

    public function getCbm(): ?string
    {
        return $this->cbm;
    }

    public function setCbm(?string $value): static
    {
        $this->cbm = $value;
        return $this;
    }

    public function getWeight(): ?string
    {
        return $this->weight;
    }

    public function setWeight(?string $value): static
    {
        $this->weight = $value;
        return $this;
    }

    public function getPartnerOtherRef(): ?string
    {
        return HtmlDecode($this->partnerOtherRef);
    }

    public function setPartnerOtherRef(?string $value): static
    {
        $this->partnerOtherRef = RemoveXss($value);
        return $this;
    }

    public function getRollNoStart(): ?int
    {
        return $this->rollNoStart;
    }

    public function setRollNoStart(?int $value): static
    {
        $this->rollNoStart = $value;
        return $this;
    }

    public function getRollNoEnd(): ?int
    {
        return $this->rollNoEnd;
    }

    public function setRollNoEnd(?int $value): static
    {
        $this->rollNoEnd = $value;
        return $this;
    }

    public function getBuyerLoc(): ?string
    {
        return HtmlDecode($this->buyerLoc);
    }

    public function setBuyerLoc(?string $value): static
    {
        $this->buyerLoc = RemoveXss($value);
        return $this;
    }

    public function getPo(): ?string
    {
        return HtmlDecode($this->po);
    }

    public function setPo(?string $value): static
    {
        $this->po = RemoveXss($value);
        return $this;
    }
}
