<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "p_stock" table
 */
#[Entity]
#[Table(name: "p_stock")]
class PStock extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "s_date", type: "datetime")]
    private DateTime $sDate;

    #[Column(name: "stock_id", type: "string", nullable: true)]
    private ?string $stockId;

    #[Column(type: "integer")]
    private int $location;

    #[Column(type: "integer")]
    private int $rid;

    #[Column(name: "packing_type", type: "smallint")]
    private int $packingType;

    #[Column(name: "lot_no", type: "string", nullable: true)]
    private ?string $lotNo;

    #[Column(name: "b_stock_packets", type: "float", nullable: true)]
    private ?float $bStockPackets;

    #[Column(name: "b_stock", type: "float")]
    private float $bStock;

    #[Column(name: "p_stock_packets", type: "float", nullable: true)]
    private ?float $pStockPackets;

    #[Column(name: "p_stock", type: "float", nullable: true)]
    private ?float $pStock;

    #[Column(name: "shortage_packets", type: "float", nullable: true)]
    private ?float $shortagePackets;

    #[Column(type: "decimal", nullable: true)]
    private ?string $shortage;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(name: "remarks_1", type: "string", nullable: true)]
    private ?string $remarks1;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getSDate(): DateTime
    {
        return $this->sDate;
    }

    public function setSDate(DateTime $value): static
    {
        $this->sDate = $value;
        return $this;
    }

    public function getStockId(): ?string
    {
        return HtmlDecode($this->stockId);
    }

    public function setStockId(?string $value): static
    {
        $this->stockId = RemoveXss($value);
        return $this;
    }

    public function getLocation(): int
    {
        return $this->location;
    }

    public function setLocation(int $value): static
    {
        $this->location = $value;
        return $this;
    }

    public function getRid(): int
    {
        return $this->rid;
    }

    public function setRid(int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getPackingType(): int
    {
        return $this->packingType;
    }

    public function setPackingType(int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getLotNo(): ?string
    {
        return HtmlDecode($this->lotNo);
    }

    public function setLotNo(?string $value): static
    {
        $this->lotNo = RemoveXss($value);
        return $this;
    }

    public function getBStockPackets(): ?float
    {
        return $this->bStockPackets;
    }

    public function setBStockPackets(?float $value): static
    {
        $this->bStockPackets = $value;
        return $this;
    }

    public function getBStock(): float
    {
        return $this->bStock;
    }

    public function setBStock(float $value): static
    {
        $this->bStock = $value;
        return $this;
    }

    public function getPStockPackets(): ?float
    {
        return $this->pStockPackets;
    }

    public function setPStockPackets(?float $value): static
    {
        $this->pStockPackets = $value;
        return $this;
    }

    public function getPStock(): ?float
    {
        return $this->pStock;
    }

    public function setPStock(?float $value): static
    {
        $this->pStock = $value;
        return $this;
    }

    public function getShortagePackets(): ?float
    {
        return $this->shortagePackets;
    }

    public function setShortagePackets(?float $value): static
    {
        $this->shortagePackets = $value;
        return $this;
    }

    public function getShortage(): ?string
    {
        return $this->shortage;
    }

    public function setShortage(?string $value): static
    {
        $this->shortage = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getRemarks1(): ?string
    {
        return HtmlDecode($this->remarks1);
    }

    public function setRemarks1(?string $value): static
    {
        $this->remarks1 = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
