<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "p_po" table
 */
#[Entity]
#[Table(name: "p_po")]
class PPo extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint", nullable: true)]
    private ?int $po;

    #[Column(type: "smallint")]
    private int $type;

    #[Column(name: "job_category", type: "integer")]
    private int $jobCategory;

    #[Column(name: "company_id", type: "integer", nullable: true)]
    private ?int $companyId;

    #[Column(type: "string")]
    private string $item;

    #[Column(type: "smallint", nullable: true)]
    private ?int $quantity;

    #[Column(name: "item_size", type: "string", nullable: true)]
    private ?string $itemSize;

    #[Column(name: "description_03", type: "string", nullable: true)]
    private ?string $description03;

    #[Column(name: "description_02", type: "string", nullable: true)]
    private ?string $description02;

    #[Column(name: "description_09", type: "string", nullable: true)]
    private ?string $description09;

    #[Column(name: "description_01", type: "string", nullable: true)]
    private ?string $description01;

    #[Column(name: "description_08", type: "string", nullable: true)]
    private ?string $description08;

    #[Column(name: "description_07", type: "string", nullable: true)]
    private ?string $description07;

    #[Column(name: "description_10", type: "string", nullable: true)]
    private ?string $description10;

    #[Column(name: "description_04", type: "string", nullable: true)]
    private ?string $description04;

    #[Column(name: "description_06", type: "string", nullable: true)]
    private ?string $description06;

    #[Column(name: "description_05", type: "string", nullable: true)]
    private ?string $description05;

    #[Column(name: "description_11", type: "string", nullable: true)]
    private ?string $description11;

    #[Column(type: "string")]
    private string $amount;

    #[Column(type: "smallint")]
    private int $gst;

    #[Column(name: "buyer_instruction", type: "string", nullable: true)]
    private ?string $buyerInstruction;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(name: "despatch_date", type: "date", nullable: true)]
    private ?DateTime $despatchDate;

    #[Column(type: "string", nullable: true)]
    private ?string $uploads;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(name: "production_plan", type: "smallint", nullable: true)]
    private ?int $productionPlan;

    #[Column(name: "part_dispatch", type: "smallint", nullable: true)]
    private ?int $partDispatch;

    #[Column(name: "payment_terms", type: "string", nullable: true)]
    private ?string $paymentTerms;

    #[Column(name: "transport_type", type: "string", nullable: true)]
    private ?string $transportType;

    #[Column(name: "partner_shipping_id", type: "smallint", nullable: true)]
    private ?int $partnerShippingId;

    #[Column(name: "description_12", type: "string", nullable: true)]
    private ?string $description12;

    #[Column(name: "description_17", type: "string", nullable: true)]
    private ?string $description17;

    #[Column(name: "description_18", type: "string", nullable: true)]
    private ?string $description18;

    #[Column(name: "description_19", type: "string", nullable: true)]
    private ?string $description19;

    #[Column(name: "description_20", type: "string", nullable: true)]
    private ?string $description20;

    #[Column(name: "production_site", type: "smallint")]
    private int $productionSite;

    #[Column(name: "jc_no", type: "string", nullable: true)]
    private ?string $jcNo;

    #[Column(name: "a_operator", type: "smallint", nullable: true)]
    private ?int $aOperator;

    #[Column(name: "a_datetime", type: "datetime", nullable: true)]
    private ?DateTime $aDatetime;

    #[Column(name: "app_operator", type: "smallint", nullable: true)]
    private ?int $appOperator;

    #[Column(name: "app_datetime", type: "datetime", nullable: true)]
    private ?DateTime $appDatetime;

    #[Column(name: "c_operator", type: "smallint", nullable: true)]
    private ?int $cOperator;

    #[Column(name: "c_datetime", type: "datetime", nullable: true)]
    private ?DateTime $cDatetime;

    public function __construct()
    {
        $this->po = 0;
        $this->type = 0;
        $this->jobCategory = 0;
        $this->companyId = ((isset($_GET["CID"]))? $_GET["CID"]:((isset($_COOKIE["CID"]))? $_COOKIE["CID"]:User_Company_ID()));
        $this->item = (isset($_COOKIE["ITEM"]))? $_COOKIE["ITEM"]:'';
        $this->quantity = (isset($_COOKIE["QTY"]))? $_COOKIE["QTY"]:'';
        $this->itemSize = (isset($_COOKIE["SIZE"]))? $_COOKIE["SIZE"]:'';
        $this->description03 = (isset($_COOKIE["D03"]))? $_COOKIE["D03"]:'';
        $this->description02 = (isset($_COOKIE["D02"]))? $_COOKIE["D02"]:'';
        $this->description09 = (isset($_COOKIE["D09"]))? $_COOKIE["D09"]:'';
        $this->description01 = (isset($_COOKIE["D01"]))? $_COOKIE["D01"]:'';
        $this->description08 = (isset($_COOKIE["D08"]))? $_COOKIE["D08"]:'';
        $this->description07 = (isset($_COOKIE["D07"]))? $_COOKIE["D07"]:'';
        $this->description10 = (isset($_COOKIE["D10"]))? $_COOKIE["D10"]:'';
        $this->description04 = (isset($_COOKIE["D04"]))? $_COOKIE["D04"]:'';
        $this->description06 = (isset($_COOKIE["D06"]))? $_COOKIE["D06"]:'';
        $this->description05 = (isset($_COOKIE["D05"]))? $_COOKIE["D05"]:'';
        $this->amount = "0";
        $this->gst = 1;
        $this->operator = 0;
        $this->description20 = "1";
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getPo(): ?int
    {
        return $this->po;
    }

    public function setPo(?int $value): static
    {
        $this->po = $value;
        return $this;
    }

    public function getType(): int
    {
        return $this->type;
    }

    public function setType(int $value): static
    {
        $this->type = $value;
        return $this;
    }

    public function getJobCategory(): int
    {
        return $this->jobCategory;
    }

    public function setJobCategory(int $value): static
    {
        $this->jobCategory = $value;
        return $this;
    }

    public function getCompanyId(): ?int
    {
        return $this->companyId;
    }

    public function setCompanyId(?int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getItem(): string
    {
        return HtmlDecode($this->item);
    }

    public function setItem(string $value): static
    {
        $this->item = RemoveXss($value);
        return $this;
    }

    public function getQuantity(): ?int
    {
        return $this->quantity;
    }

    public function setQuantity(?int $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getItemSize(): ?string
    {
        return HtmlDecode($this->itemSize);
    }

    public function setItemSize(?string $value): static
    {
        $this->itemSize = RemoveXss($value);
        return $this;
    }

    public function getDescription03(): ?string
    {
        return HtmlDecode($this->description03);
    }

    public function setDescription03(?string $value): static
    {
        $this->description03 = RemoveXss($value);
        return $this;
    }

    public function getDescription02(): ?string
    {
        return HtmlDecode($this->description02);
    }

    public function setDescription02(?string $value): static
    {
        $this->description02 = RemoveXss($value);
        return $this;
    }

    public function getDescription09(): ?string
    {
        return HtmlDecode($this->description09);
    }

    public function setDescription09(?string $value): static
    {
        $this->description09 = RemoveXss($value);
        return $this;
    }

    public function getDescription01(): ?string
    {
        return HtmlDecode($this->description01);
    }

    public function setDescription01(?string $value): static
    {
        $this->description01 = RemoveXss($value);
        return $this;
    }

    public function getDescription08(): ?string
    {
        return HtmlDecode($this->description08);
    }

    public function setDescription08(?string $value): static
    {
        $this->description08 = RemoveXss($value);
        return $this;
    }

    public function getDescription07(): ?string
    {
        return HtmlDecode($this->description07);
    }

    public function setDescription07(?string $value): static
    {
        $this->description07 = RemoveXss($value);
        return $this;
    }

    public function getDescription10(): ?string
    {
        return HtmlDecode($this->description10);
    }

    public function setDescription10(?string $value): static
    {
        $this->description10 = RemoveXss($value);
        return $this;
    }

    public function getDescription04(): ?string
    {
        return HtmlDecode($this->description04);
    }

    public function setDescription04(?string $value): static
    {
        $this->description04 = RemoveXss($value);
        return $this;
    }

    public function getDescription06(): ?string
    {
        return HtmlDecode($this->description06);
    }

    public function setDescription06(?string $value): static
    {
        $this->description06 = RemoveXss($value);
        return $this;
    }

    public function getDescription05(): ?string
    {
        return HtmlDecode($this->description05);
    }

    public function setDescription05(?string $value): static
    {
        $this->description05 = RemoveXss($value);
        return $this;
    }

    public function getDescription11(): ?string
    {
        return HtmlDecode($this->description11);
    }

    public function setDescription11(?string $value): static
    {
        $this->description11 = RemoveXss($value);
        return $this;
    }

    public function getAmount(): string
    {
        return HtmlDecode($this->amount);
    }

    public function setAmount(string $value): static
    {
        $this->amount = RemoveXss($value);
        return $this;
    }

    public function getGst(): int
    {
        return $this->gst;
    }

    public function setGst(int $value): static
    {
        $this->gst = $value;
        return $this;
    }

    public function getBuyerInstruction(): ?string
    {
        return HtmlDecode($this->buyerInstruction);
    }

    public function setBuyerInstruction(?string $value): static
    {
        $this->buyerInstruction = RemoveXss($value);
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getDespatchDate(): ?DateTime
    {
        return $this->despatchDate;
    }

    public function setDespatchDate(?DateTime $value): static
    {
        $this->despatchDate = $value;
        return $this;
    }

    public function getUploads(): ?string
    {
        return HtmlDecode($this->uploads);
    }

    public function setUploads(?string $value): static
    {
        $this->uploads = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getProductionPlan(): ?int
    {
        return $this->productionPlan;
    }

    public function setProductionPlan(?int $value): static
    {
        $this->productionPlan = $value;
        return $this;
    }

    public function getPartDispatch(): ?int
    {
        return $this->partDispatch;
    }

    public function setPartDispatch(?int $value): static
    {
        $this->partDispatch = $value;
        return $this;
    }

    public function getPaymentTerms(): ?string
    {
        return HtmlDecode($this->paymentTerms);
    }

    public function setPaymentTerms(?string $value): static
    {
        $this->paymentTerms = RemoveXss($value);
        return $this;
    }

    public function getTransportType(): ?string
    {
        return HtmlDecode($this->transportType);
    }

    public function setTransportType(?string $value): static
    {
        $this->transportType = RemoveXss($value);
        return $this;
    }

    public function getPartnerShippingId(): ?int
    {
        return $this->partnerShippingId;
    }

    public function setPartnerShippingId(?int $value): static
    {
        $this->partnerShippingId = $value;
        return $this;
    }

    public function getDescription12(): ?string
    {
        return HtmlDecode($this->description12);
    }

    public function setDescription12(?string $value): static
    {
        $this->description12 = RemoveXss($value);
        return $this;
    }

    public function getDescription17(): ?string
    {
        return HtmlDecode($this->description17);
    }

    public function setDescription17(?string $value): static
    {
        $this->description17 = RemoveXss($value);
        return $this;
    }

    public function getDescription18(): ?string
    {
        return HtmlDecode($this->description18);
    }

    public function setDescription18(?string $value): static
    {
        $this->description18 = RemoveXss($value);
        return $this;
    }

    public function getDescription19(): ?string
    {
        return HtmlDecode($this->description19);
    }

    public function setDescription19(?string $value): static
    {
        $this->description19 = RemoveXss($value);
        return $this;
    }

    public function getDescription20(): ?string
    {
        return HtmlDecode($this->description20);
    }

    public function setDescription20(?string $value): static
    {
        $this->description20 = RemoveXss($value);
        return $this;
    }

    public function getProductionSite(): int
    {
        return $this->productionSite;
    }

    public function setProductionSite(int $value): static
    {
        $this->productionSite = $value;
        return $this;
    }

    public function getJcNo(): ?string
    {
        return HtmlDecode($this->jcNo);
    }

    public function setJcNo(?string $value): static
    {
        $this->jcNo = RemoveXss($value);
        return $this;
    }

    public function getAOperator(): ?int
    {
        return $this->aOperator;
    }

    public function setAOperator(?int $value): static
    {
        $this->aOperator = $value;
        return $this;
    }

    public function getADatetime(): ?DateTime
    {
        return $this->aDatetime;
    }

    public function setADatetime(?DateTime $value): static
    {
        $this->aDatetime = $value;
        return $this;
    }

    public function getAppOperator(): ?int
    {
        return $this->appOperator;
    }

    public function setAppOperator(?int $value): static
    {
        $this->appOperator = $value;
        return $this;
    }

    public function getAppDatetime(): ?DateTime
    {
        return $this->appDatetime;
    }

    public function setAppDatetime(?DateTime $value): static
    {
        $this->appDatetime = $value;
        return $this;
    }

    public function getCOperator(): ?int
    {
        return $this->cOperator;
    }

    public function setCOperator(?int $value): static
    {
        $this->cOperator = $value;
        return $this;
    }

    public function getCDatetime(): ?DateTime
    {
        return $this->cDatetime;
    }

    public function setCDatetime(?DateTime $value): static
    {
        $this->cDatetime = $value;
        return $this;
    }
}
