<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "p_eastimate" table
 */
#[Entity]
#[Table(name: "p_eastimate")]
class PEastimate extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "job_type", type: "smallint")]
    private int $jobType;

    #[Column(name: "job_category", type: "smallint")]
    private int $jobCategory;

    #[Column(name: "company_id", type: "smallint", nullable: true)]
    private ?int $companyId;

    #[Column(type: "string", nullable: true)]
    private ?string $description;

    #[Column(type: "string")]
    private string $size;

    #[Column(type: "decimal")]
    private string $quantity;

    #[Column(type: "string")]
    private string $pages;

    #[Column(type: "smallint", nullable: true)]
    private ?int $paper;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(name: "pr_01", type: "string", nullable: true)]
    private ?string $pr01;

    #[Column(name: "qty_pr_01", type: "decimal")]
    private string $qtyPr01;

    #[Column(name: "pl_01", type: "string", nullable: true)]
    private ?string $pl01;

    #[Column(name: "qty_pl_01", type: "decimal")]
    private string $qtyPl01;

    #[Column(name: "pr_02", type: "string", nullable: true)]
    private ?string $pr02;

    #[Column(name: "qty_pr_02", type: "decimal")]
    private string $qtyPr02;

    #[Column(name: "pl_02", type: "string", nullable: true)]
    private ?string $pl02;

    #[Column(name: "qty_pl_02", type: "decimal")]
    private string $qtyPl02;

    #[Column(name: "pr_03", type: "string", nullable: true)]
    private ?string $pr03;

    #[Column(name: "qty_pr_03", type: "decimal")]
    private string $qtyPr03;

    #[Column(name: "pl_03", type: "string", nullable: true)]
    private ?string $pl03;

    #[Column(name: "qty_pl_03", type: "decimal")]
    private string $qtyPl03;

    #[Column(name: "pr_04", type: "string", nullable: true)]
    private ?string $pr04;

    #[Column(name: "qty_pr_04", type: "decimal")]
    private string $qtyPr04;

    #[Column(name: "pl_04", type: "string", nullable: true)]
    private ?string $pl04;

    #[Column(name: "qty_pl_04", type: "decimal")]
    private string $qtyPl04;

    #[Column(name: "pa_01", type: "string", nullable: true)]
    private ?string $pa01;

    #[Column(name: "qty_pa_01", type: "decimal")]
    private string $qtyPa01;

    #[Column(name: "pa_02", type: "string", nullable: true)]
    private ?string $pa02;

    #[Column(name: "qty_pa_02", type: "decimal")]
    private string $qtyPa02;

    #[Column(name: "pa_03", type: "string", nullable: true)]
    private ?string $pa03;

    #[Column(name: "qty_pa_03", type: "decimal")]
    private string $qtyPa03;

    #[Column(name: "pa_04", type: "string", nullable: true)]
    private ?string $pa04;

    #[Column(name: "qty_pa_04", type: "decimal")]
    private string $qtyPa04;

    #[Column(name: "pa_05", type: "string", nullable: true)]
    private ?string $pa05;

    #[Column(name: "qty_pa_05", type: "decimal")]
    private string $qtyPa05;

    #[Column(name: "pc_01", type: "string", nullable: true)]
    private ?string $pc01;

    #[Column(name: "qty_pc_01", type: "decimal")]
    private string $qtyPc01;

    #[Column(name: "pc_02", type: "string", nullable: true)]
    private ?string $pc02;

    #[Column(name: "qty_pc_02", type: "decimal")]
    private string $qtyPc02;

    #[Column(name: "o_01", type: "string", nullable: true)]
    private ?string $o01;

    #[Column(name: "qty_o_01", type: "decimal")]
    private string $qtyO01;

    #[Column(name: "lamination_type", type: "string", nullable: true)]
    private ?string $laminationType;

    #[Column(name: "lamination_qty", type: "integer", nullable: true)]
    private ?int $laminationQty;

    #[Column(name: "die_type", type: "string", nullable: true)]
    private ?string $dieType;

    #[Column(name: "die_qty", type: "smallint")]
    private int $dieQty;

    #[Column(name: "binding_type", type: "string", nullable: true)]
    private ?string $bindingType;

    #[Column(name: "binding_qty", type: "decimal")]
    private string $bindingQty;

    #[Column(name: "number_type", type: "string", nullable: true)]
    private ?string $numberType;

    #[Column(name: "number_qty", type: "integer")]
    private int $numberQty;

    #[Column(name: "de_01", type: "string", nullable: true)]
    private ?string $de01;

    #[Column(name: "qty_de_01", type: "decimal")]
    private string $qtyDe01;

    #[Column(name: "de_02", type: "string", nullable: true)]
    private ?string $de02;

    #[Column(name: "qty_de_02", type: "decimal")]
    private string $qtyDe02;

    #[Column(name: "de_03", type: "string", nullable: true)]
    private ?string $de03;

    #[Column(name: "qty_de_03", type: "decimal")]
    private string $qtyDe03;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    public function __construct()
    {
        $this->companyId = ((isset($_GET["CID"]))? $_GET["CID"]:((isset($_COOKIE["CID"]))? $_COOKIE["CID"]:User_Company_ID()));
        $this->quantity = "0.00";
        $this->pages = "0";
        $this->paper = 1;
        $this->qtyPr01 = "0.00";
        $this->qtyPl01 = "0.00";
        $this->qtyPr02 = "0.00";
        $this->qtyPl02 = "0.00";
        $this->qtyPr03 = "0.00";
        $this->qtyPl03 = "0.00";
        $this->qtyPr04 = "0.00";
        $this->qtyPl04 = "0.00";
        $this->qtyPa01 = "0.00";
        $this->qtyPa02 = "0.00";
        $this->qtyPa03 = "0.00";
        $this->qtyPa04 = "0.00";
        $this->qtyPa05 = "0.00";
        $this->qtyPc01 = "0.00";
        $this->qtyPc02 = "0.00";
        $this->qtyO01 = "0.00";
        $this->laminationQty = 0.00;
        $this->dieQty = 0.00;
        $this->bindingQty = "0.00";
        $this->numberQty = 0.00;
        $this->qtyDe01 = "0.00";
        $this->qtyDe02 = "0.00";
        $this->qtyDe03 = "0.00";
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getJobType(): int
    {
        return $this->jobType;
    }

    public function setJobType(int $value): static
    {
        $this->jobType = $value;
        return $this;
    }

    public function getJobCategory(): int
    {
        return $this->jobCategory;
    }

    public function setJobCategory(int $value): static
    {
        $this->jobCategory = $value;
        return $this;
    }

    public function getCompanyId(): ?int
    {
        return $this->companyId;
    }

    public function setCompanyId(?int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getDescription(): ?string
    {
        return HtmlDecode($this->description);
    }

    public function setDescription(?string $value): static
    {
        $this->description = RemoveXss($value);
        return $this;
    }

    public function getSize(): string
    {
        return HtmlDecode($this->size);
    }

    public function setSize(string $value): static
    {
        $this->size = RemoveXss($value);
        return $this;
    }

    public function getQuantity(): string
    {
        return $this->quantity;
    }

    public function setQuantity(string $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getPages(): string
    {
        return HtmlDecode($this->pages);
    }

    public function setPages(string $value): static
    {
        $this->pages = RemoveXss($value);
        return $this;
    }

    public function getPaper(): ?int
    {
        return $this->paper;
    }

    public function setPaper(?int $value): static
    {
        $this->paper = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getPr01(): ?string
    {
        return HtmlDecode($this->pr01);
    }

    public function setPr01(?string $value): static
    {
        $this->pr01 = RemoveXss($value);
        return $this;
    }

    public function getQtyPr01(): string
    {
        return $this->qtyPr01;
    }

    public function setQtyPr01(string $value): static
    {
        $this->qtyPr01 = $value;
        return $this;
    }

    public function getPl01(): ?string
    {
        return HtmlDecode($this->pl01);
    }

    public function setPl01(?string $value): static
    {
        $this->pl01 = RemoveXss($value);
        return $this;
    }

    public function getQtyPl01(): string
    {
        return $this->qtyPl01;
    }

    public function setQtyPl01(string $value): static
    {
        $this->qtyPl01 = $value;
        return $this;
    }

    public function getPr02(): ?string
    {
        return HtmlDecode($this->pr02);
    }

    public function setPr02(?string $value): static
    {
        $this->pr02 = RemoveXss($value);
        return $this;
    }

    public function getQtyPr02(): string
    {
        return $this->qtyPr02;
    }

    public function setQtyPr02(string $value): static
    {
        $this->qtyPr02 = $value;
        return $this;
    }

    public function getPl02(): ?string
    {
        return HtmlDecode($this->pl02);
    }

    public function setPl02(?string $value): static
    {
        $this->pl02 = RemoveXss($value);
        return $this;
    }

    public function getQtyPl02(): string
    {
        return $this->qtyPl02;
    }

    public function setQtyPl02(string $value): static
    {
        $this->qtyPl02 = $value;
        return $this;
    }

    public function getPr03(): ?string
    {
        return HtmlDecode($this->pr03);
    }

    public function setPr03(?string $value): static
    {
        $this->pr03 = RemoveXss($value);
        return $this;
    }

    public function getQtyPr03(): string
    {
        return $this->qtyPr03;
    }

    public function setQtyPr03(string $value): static
    {
        $this->qtyPr03 = $value;
        return $this;
    }

    public function getPl03(): ?string
    {
        return HtmlDecode($this->pl03);
    }

    public function setPl03(?string $value): static
    {
        $this->pl03 = RemoveXss($value);
        return $this;
    }

    public function getQtyPl03(): string
    {
        return $this->qtyPl03;
    }

    public function setQtyPl03(string $value): static
    {
        $this->qtyPl03 = $value;
        return $this;
    }

    public function getPr04(): ?string
    {
        return HtmlDecode($this->pr04);
    }

    public function setPr04(?string $value): static
    {
        $this->pr04 = RemoveXss($value);
        return $this;
    }

    public function getQtyPr04(): string
    {
        return $this->qtyPr04;
    }

    public function setQtyPr04(string $value): static
    {
        $this->qtyPr04 = $value;
        return $this;
    }

    public function getPl04(): ?string
    {
        return HtmlDecode($this->pl04);
    }

    public function setPl04(?string $value): static
    {
        $this->pl04 = RemoveXss($value);
        return $this;
    }

    public function getQtyPl04(): string
    {
        return $this->qtyPl04;
    }

    public function setQtyPl04(string $value): static
    {
        $this->qtyPl04 = $value;
        return $this;
    }

    public function getPa01(): ?string
    {
        return HtmlDecode($this->pa01);
    }

    public function setPa01(?string $value): static
    {
        $this->pa01 = RemoveXss($value);
        return $this;
    }

    public function getQtyPa01(): string
    {
        return $this->qtyPa01;
    }

    public function setQtyPa01(string $value): static
    {
        $this->qtyPa01 = $value;
        return $this;
    }

    public function getPa02(): ?string
    {
        return HtmlDecode($this->pa02);
    }

    public function setPa02(?string $value): static
    {
        $this->pa02 = RemoveXss($value);
        return $this;
    }

    public function getQtyPa02(): string
    {
        return $this->qtyPa02;
    }

    public function setQtyPa02(string $value): static
    {
        $this->qtyPa02 = $value;
        return $this;
    }

    public function getPa03(): ?string
    {
        return HtmlDecode($this->pa03);
    }

    public function setPa03(?string $value): static
    {
        $this->pa03 = RemoveXss($value);
        return $this;
    }

    public function getQtyPa03(): string
    {
        return $this->qtyPa03;
    }

    public function setQtyPa03(string $value): static
    {
        $this->qtyPa03 = $value;
        return $this;
    }

    public function getPa04(): ?string
    {
        return HtmlDecode($this->pa04);
    }

    public function setPa04(?string $value): static
    {
        $this->pa04 = RemoveXss($value);
        return $this;
    }

    public function getQtyPa04(): string
    {
        return $this->qtyPa04;
    }

    public function setQtyPa04(string $value): static
    {
        $this->qtyPa04 = $value;
        return $this;
    }

    public function getPa05(): ?string
    {
        return HtmlDecode($this->pa05);
    }

    public function setPa05(?string $value): static
    {
        $this->pa05 = RemoveXss($value);
        return $this;
    }

    public function getQtyPa05(): string
    {
        return $this->qtyPa05;
    }

    public function setQtyPa05(string $value): static
    {
        $this->qtyPa05 = $value;
        return $this;
    }

    public function getPc01(): ?string
    {
        return HtmlDecode($this->pc01);
    }

    public function setPc01(?string $value): static
    {
        $this->pc01 = RemoveXss($value);
        return $this;
    }

    public function getQtyPc01(): string
    {
        return $this->qtyPc01;
    }

    public function setQtyPc01(string $value): static
    {
        $this->qtyPc01 = $value;
        return $this;
    }

    public function getPc02(): ?string
    {
        return HtmlDecode($this->pc02);
    }

    public function setPc02(?string $value): static
    {
        $this->pc02 = RemoveXss($value);
        return $this;
    }

    public function getQtyPc02(): string
    {
        return $this->qtyPc02;
    }

    public function setQtyPc02(string $value): static
    {
        $this->qtyPc02 = $value;
        return $this;
    }

    public function getO01(): ?string
    {
        return HtmlDecode($this->o01);
    }

    public function setO01(?string $value): static
    {
        $this->o01 = RemoveXss($value);
        return $this;
    }

    public function getQtyO01(): string
    {
        return $this->qtyO01;
    }

    public function setQtyO01(string $value): static
    {
        $this->qtyO01 = $value;
        return $this;
    }

    public function getLaminationType(): ?string
    {
        return HtmlDecode($this->laminationType);
    }

    public function setLaminationType(?string $value): static
    {
        $this->laminationType = RemoveXss($value);
        return $this;
    }

    public function getLaminationQty(): ?int
    {
        return $this->laminationQty;
    }

    public function setLaminationQty(?int $value): static
    {
        $this->laminationQty = $value;
        return $this;
    }

    public function getDieType(): ?string
    {
        return HtmlDecode($this->dieType);
    }

    public function setDieType(?string $value): static
    {
        $this->dieType = RemoveXss($value);
        return $this;
    }

    public function getDieQty(): int
    {
        return $this->dieQty;
    }

    public function setDieQty(int $value): static
    {
        $this->dieQty = $value;
        return $this;
    }

    public function getBindingType(): ?string
    {
        return HtmlDecode($this->bindingType);
    }

    public function setBindingType(?string $value): static
    {
        $this->bindingType = RemoveXss($value);
        return $this;
    }

    public function getBindingQty(): string
    {
        return $this->bindingQty;
    }

    public function setBindingQty(string $value): static
    {
        $this->bindingQty = $value;
        return $this;
    }

    public function getNumberType(): ?string
    {
        return HtmlDecode($this->numberType);
    }

    public function setNumberType(?string $value): static
    {
        $this->numberType = RemoveXss($value);
        return $this;
    }

    public function getNumberQty(): int
    {
        return $this->numberQty;
    }

    public function setNumberQty(int $value): static
    {
        $this->numberQty = $value;
        return $this;
    }

    public function getDe01(): ?string
    {
        return HtmlDecode($this->de01);
    }

    public function setDe01(?string $value): static
    {
        $this->de01 = RemoveXss($value);
        return $this;
    }

    public function getQtyDe01(): string
    {
        return $this->qtyDe01;
    }

    public function setQtyDe01(string $value): static
    {
        $this->qtyDe01 = $value;
        return $this;
    }

    public function getDe02(): ?string
    {
        return HtmlDecode($this->de02);
    }

    public function setDe02(?string $value): static
    {
        $this->de02 = RemoveXss($value);
        return $this;
    }

    public function getQtyDe02(): string
    {
        return $this->qtyDe02;
    }

    public function setQtyDe02(string $value): static
    {
        $this->qtyDe02 = $value;
        return $this;
    }

    public function getDe03(): ?string
    {
        return HtmlDecode($this->de03);
    }

    public function setDe03(?string $value): static
    {
        $this->de03 = RemoveXss($value);
        return $this;
    }

    public function getQtyDe03(): string
    {
        return $this->qtyDe03;
    }

    public function setQtyDe03(string $value): static
    {
        $this->qtyDe03 = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
