<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "other_all" table
 */
#[Entity]
#[Table(name: "other_all")]
class OtherAll extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $location;

    #[Column(name: "emp_id", type: "string")]
    private string $empId;

    #[Column(type: "string", unique: true, nullable: true)]
    private ?string $item;

    #[Column(type: "decimal")]
    private string $quantity;

    #[Column(type: "decimal")]
    private string $amount;

    #[Column(type: "string")]
    private string $description;

    #[Column(type: "string")]
    private string $upload;

    #[Column(type: "smallint", nullable: true)]
    private ?int $payment;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(name: "e_operator", type: "smallint", nullable: true)]
    private ?int $eOperator;

    #[Column(name: "e_datetime", type: "datetime", nullable: true)]
    private ?DateTime $eDatetime;

    public function __construct()
    {
        $this->location = ((isset($_COOKIE["Location"]))? $_COOKIE["Location"]:'');
        $this->quantity = "1";
        $this->amount = "0";
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getLocation(): int
    {
        return $this->location;
    }

    public function setLocation(int $value): static
    {
        $this->location = $value;
        return $this;
    }

    public function getEmpId(): string
    {
        return HtmlDecode($this->empId);
    }

    public function setEmpId(string $value): static
    {
        $this->empId = RemoveXss($value);
        return $this;
    }

    public function getItem(): ?string
    {
        return HtmlDecode($this->item);
    }

    public function setItem(?string $value): static
    {
        $this->item = RemoveXss($value);
        return $this;
    }

    public function getQuantity(): string
    {
        return $this->quantity;
    }

    public function setQuantity(string $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getAmount(): string
    {
        return $this->amount;
    }

    public function setAmount(string $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getDescription(): string
    {
        return HtmlDecode($this->description);
    }

    public function setDescription(string $value): static
    {
        $this->description = RemoveXss($value);
        return $this;
    }

    public function getUpload(): string
    {
        return HtmlDecode($this->upload);
    }

    public function setUpload(string $value): static
    {
        $this->upload = RemoveXss($value);
        return $this;
    }

    public function getPayment(): ?int
    {
        return $this->payment;
    }

    public function setPayment(?int $value): static
    {
        $this->payment = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getEOperator(): ?int
    {
        return $this->eOperator;
    }

    public function setEOperator(?int $value): static
    {
        $this->eOperator = $value;
        return $this;
    }

    public function getEDatetime(): ?DateTime
    {
        return $this->eDatetime;
    }

    public function setEDatetime(?DateTime $value): static
    {
        $this->eDatetime = $value;
        return $this;
    }
}
