<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "not week" table
 */
#[Entity]
#[Table(name: "`not week`")]
class NotWeek extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string", nullable: true)]
    private ?string $week;

    #[Column(type: "string", nullable: true)]
    private ?string $nweek;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $weekstartday;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $weekendday;

    #[Column(type: "string", nullable: true)]
    private ?string $wsd;

    #[Column(type: "string", nullable: true)]
    private ?string $wed;

    #[Column(type: "integer", nullable: true)]
    private ?int $wid;

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getWeek(): ?string
    {
        return HtmlDecode($this->week);
    }

    public function setWeek(?string $value): static
    {
        $this->week = RemoveXss($value);
        return $this;
    }

    public function getNweek(): ?string
    {
        return HtmlDecode($this->nweek);
    }

    public function setNweek(?string $value): static
    {
        $this->nweek = RemoveXss($value);
        return $this;
    }

    public function getWeekstartday(): ?DateTime
    {
        return $this->weekstartday;
    }

    public function setWeekstartday(?DateTime $value): static
    {
        $this->weekstartday = $value;
        return $this;
    }

    public function getWeekendday(): ?DateTime
    {
        return $this->weekendday;
    }

    public function setWeekendday(?DateTime $value): static
    {
        $this->weekendday = $value;
        return $this;
    }

    public function getWsd(): ?string
    {
        return HtmlDecode($this->wsd);
    }

    public function setWsd(?string $value): static
    {
        $this->wsd = RemoveXss($value);
        return $this;
    }

    public function getWed(): ?string
    {
        return HtmlDecode($this->wed);
    }

    public function setWed(?string $value): static
    {
        $this->wed = RemoveXss($value);
        return $this;
    }

    public function getWid(): ?int
    {
        return $this->wid;
    }

    public function setWid(?int $value): static
    {
        $this->wid = $value;
        return $this;
    }
}
