<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "not_loomcard" table
 */
#[Entity]
#[Table(name: "not_loomcard")]
class NotLoomcard extends AbstractEntity
{
    #[Column(type: "integer", nullable: true)]
    private ?int $po;

    #[Column(type: "integer")]
    private int $barcode;

    #[Column(name: "design_size", type: "string", nullable: true)]
    private ?string $designSize;

    #[Column(name: "weaving_works", type: "smallint")]
    private int $weavingWorks;

    #[Column(type: "smallint", nullable: true)]
    private ?int $grp;

    #[Column(name: "size_cm", type: "string")]
    private string $sizeCm;

    #[Column(name: "w_cm", type: "smallint", nullable: true)]
    private ?int $wCm;

    #[Column(type: "string")]
    private string $category;

    #[Column(name: "po_d", type: "string", nullable: true)]
    private ?string $poD;

    #[Column(name: "loom_week", type: "string")]
    private string $loomWeek;

    #[Column(name: "loom_size", type: "string")]
    private string $loomSize;

    #[Column(name: "extra_loom_week", type: "smallint", nullable: true)]
    private ?int $extraLoomWeek;

    #[Column(name: "design_id", type: "string", nullable: true)]
    private ?string $designId;

    #[Column(name: "packing_type", type: "smallint", nullable: true)]
    private ?int $packingType;

    #[Column(name: "buyers_id", type: "integer", nullable: true)]
    private ?int $buyersId;

    #[Column(type: "string", nullable: true)]
    private ?string $sort;

    public function __construct()
    {
        $this->barcode = 0;
        $this->weavingWorks = 0;
        $this->packingType = 301;
    }

    public function getPo(): ?int
    {
        return $this->po;
    }

    public function setPo(?int $value): static
    {
        $this->po = $value;
        return $this;
    }

    public function getBarcode(): int
    {
        return $this->barcode;
    }

    public function setBarcode(int $value): static
    {
        $this->barcode = $value;
        return $this;
    }

    public function getDesignSize(): ?string
    {
        return HtmlDecode($this->designSize);
    }

    public function setDesignSize(?string $value): static
    {
        $this->designSize = RemoveXss($value);
        return $this;
    }

    public function getWeavingWorks(): int
    {
        return $this->weavingWorks;
    }

    public function setWeavingWorks(int $value): static
    {
        $this->weavingWorks = $value;
        return $this;
    }

    public function getGrp(): ?int
    {
        return $this->grp;
    }

    public function setGrp(?int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSizeCm(): string
    {
        return HtmlDecode($this->sizeCm);
    }

    public function setSizeCm(string $value): static
    {
        $this->sizeCm = RemoveXss($value);
        return $this;
    }

    public function getWCm(): ?int
    {
        return $this->wCm;
    }

    public function setWCm(?int $value): static
    {
        $this->wCm = $value;
        return $this;
    }

    public function getCategory(): string
    {
        return HtmlDecode($this->category);
    }

    public function setCategory(string $value): static
    {
        $this->category = RemoveXss($value);
        return $this;
    }

    public function getPoD(): ?string
    {
        return HtmlDecode($this->poD);
    }

    public function setPoD(?string $value): static
    {
        $this->poD = RemoveXss($value);
        return $this;
    }

    public function getLoomWeek(): string
    {
        return HtmlDecode($this->loomWeek);
    }

    public function setLoomWeek(string $value): static
    {
        $this->loomWeek = RemoveXss($value);
        return $this;
    }

    public function getLoomSize(): string
    {
        return HtmlDecode($this->loomSize);
    }

    public function setLoomSize(string $value): static
    {
        $this->loomSize = RemoveXss($value);
        return $this;
    }

    public function getExtraLoomWeek(): ?int
    {
        return $this->extraLoomWeek;
    }

    public function setExtraLoomWeek(?int $value): static
    {
        $this->extraLoomWeek = $value;
        return $this;
    }

    public function getDesignId(): ?string
    {
        return HtmlDecode($this->designId);
    }

    public function setDesignId(?string $value): static
    {
        $this->designId = RemoveXss($value);
        return $this;
    }

    public function getPackingType(): ?int
    {
        return $this->packingType;
    }

    public function setPackingType(?int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getBuyersId(): ?int
    {
        return $this->buyersId;
    }

    public function setBuyersId(?int $value): static
    {
        $this->buyersId = $value;
        return $this;
    }

    public function getSort(): ?string
    {
        return HtmlDecode($this->sort);
    }

    public function setSort(?string $value): static
    {
        $this->sort = RemoveXss($value);
        return $this;
    }
}
