<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "multiple_price" table
 */
#[Entity]
#[Table(name: "multiple_price")]
class MultiplePrice extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "company_id", type: "integer")]
    private int $companyId;

    #[Column(name: "buyer_id", type: "string")]
    private string $buyerId;

    #[Column(type: "smallint")]
    private int $grp;

    #[Column(type: "smallint")]
    private int $product;

    #[Column(type: "bigint")]
    private string $code;

    #[Column(name: "packing_type", type: "smallint")]
    private int $packingType;

    #[Column(type: "integer")]
    private int $level;

    #[Column(name: "min_qty", type: "integer")]
    private int $minQty;

    #[Column(name: "max_qty", type: "integer")]
    private int $maxQty;

    #[Column(type: "smallint")]
    private int $increment;

    #[Column(name: "price_min_qty", type: "decimal")]
    private string $priceMinQty;

    #[Column(type: "smallint")]
    private int $currency;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(name: "s_grp", type: "smallint")]
    private int $sGrp;

    public function __construct()
    {
        $this->companyId = 0;
        $this->buyerId = "0";
        $this->currency = 1;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getCompanyId(): int
    {
        return $this->companyId;
    }

    public function setCompanyId(int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getBuyerId(): string
    {
        return HtmlDecode($this->buyerId);
    }

    public function setBuyerId(string $value): static
    {
        $this->buyerId = RemoveXss($value);
        return $this;
    }

    public function getGrp(): int
    {
        return $this->grp;
    }

    public function setGrp(int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getProduct(): int
    {
        return $this->product;
    }

    public function setProduct(int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function setCode(string $value): static
    {
        $this->code = $value;
        return $this;
    }

    public function getPackingType(): int
    {
        return $this->packingType;
    }

    public function setPackingType(int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getLevel(): int
    {
        return $this->level;
    }

    public function setLevel(int $value): static
    {
        $this->level = $value;
        return $this;
    }

    public function getMinQty(): int
    {
        return $this->minQty;
    }

    public function setMinQty(int $value): static
    {
        $this->minQty = $value;
        return $this;
    }

    public function getMaxQty(): int
    {
        return $this->maxQty;
    }

    public function setMaxQty(int $value): static
    {
        $this->maxQty = $value;
        return $this;
    }

    public function getIncrement(): int
    {
        return $this->increment;
    }

    public function setIncrement(int $value): static
    {
        $this->increment = $value;
        return $this;
    }

    public function getPriceMinQty(): string
    {
        return $this->priceMinQty;
    }

    public function setPriceMinQty(string $value): static
    {
        $this->priceMinQty = $value;
        return $this;
    }

    public function getCurrency(): int
    {
        return $this->currency;
    }

    public function setCurrency(int $value): static
    {
        $this->currency = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getSGrp(): int
    {
        return $this->sGrp;
    }

    public function setSGrp(int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }
}
