<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "mgs_certificate_data" table
 */
#[Entity]
#[Table(name: "mgs_certificate_data")]
class MgsCertificateDatum extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "certificate_id", type: "smallint")]
    private int $certificateId;

    #[Column(type: "string", nullable: true)]
    private ?string $name;

    #[Column(name: "line_1", type: "string", nullable: true)]
    private ?string $line1;

    #[Column(name: "line_2", type: "string", nullable: true)]
    private ?string $line2;

    #[Column(name: "e_mail", type: "string")]
    private string $eMail;

    #[Column(type: "integer")]
    private int $updated;

    #[Column(type: "string")]
    private string $jpg;

    #[Column(type: "string")]
    private string $pdf;

    #[Column(name: "mail_status", type: "string")]
    private string $mailStatus;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->updated = 0;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getCertificateId(): int
    {
        return $this->certificateId;
    }

    public function setCertificateId(int $value): static
    {
        $this->certificateId = $value;
        return $this;
    }

    public function getName(): ?string
    {
        return HtmlDecode($this->name);
    }

    public function setName(?string $value): static
    {
        $this->name = RemoveXss($value);
        return $this;
    }

    public function getLine1(): ?string
    {
        return HtmlDecode($this->line1);
    }

    public function setLine1(?string $value): static
    {
        $this->line1 = RemoveXss($value);
        return $this;
    }

    public function getLine2(): ?string
    {
        return HtmlDecode($this->line2);
    }

    public function setLine2(?string $value): static
    {
        $this->line2 = RemoveXss($value);
        return $this;
    }

    public function getEMail(): string
    {
        return HtmlDecode($this->eMail);
    }

    public function setEMail(string $value): static
    {
        $this->eMail = RemoveXss($value);
        return $this;
    }

    public function getUpdated(): int
    {
        return $this->updated;
    }

    public function setUpdated(int $value): static
    {
        $this->updated = $value;
        return $this;
    }

    public function getJpg(): string
    {
        return HtmlDecode($this->jpg);
    }

    public function setJpg(string $value): static
    {
        $this->jpg = RemoveXss($value);
        return $this;
    }

    public function getPdf(): string
    {
        return HtmlDecode($this->pdf);
    }

    public function setPdf(string $value): static
    {
        $this->pdf = RemoveXss($value);
        return $this;
    }

    public function getMailStatus(): string
    {
        return HtmlDecode($this->mailStatus);
    }

    public function setMailStatus(string $value): static
    {
        $this->mailStatus = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
