<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "mgs_certificate" table
 */
#[Entity]
#[Table(name: "mgs_certificate")]
class MgsCertificate extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string")]
    private string $dated;

    #[Column(type: "string")]
    private string $title;

    #[Column(name: "m_from", type: "string")]
    private string $mFrom;

    #[Column(name: "reply_to", type: "string")]
    private string $replyTo;

    #[Column(type: "text")]
    private string $subject;

    #[Column(type: "text")]
    private string $message;

    #[Column(name: "certificate_image", type: "string", nullable: true)]
    private ?string $certificateImage;

    #[Column(type: "string", nullable: true)]
    private ?string $font;

    #[Column(type: "integer", nullable: true)]
    private ?int $status;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(name: "m_from_name", type: "string", nullable: true)]
    private ?string $mFromName;

    public function __construct()
    {
        $this->status = 0;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getDated(): string
    {
        return HtmlDecode($this->dated);
    }

    public function setDated(string $value): static
    {
        $this->dated = RemoveXss($value);
        return $this;
    }

    public function getTitle(): string
    {
        return HtmlDecode($this->title);
    }

    public function setTitle(string $value): static
    {
        $this->title = RemoveXss($value);
        return $this;
    }

    public function getMFrom(): string
    {
        return HtmlDecode($this->mFrom);
    }

    public function setMFrom(string $value): static
    {
        $this->mFrom = RemoveXss($value);
        return $this;
    }

    public function getReplyTo(): string
    {
        return HtmlDecode($this->replyTo);
    }

    public function setReplyTo(string $value): static
    {
        $this->replyTo = RemoveXss($value);
        return $this;
    }

    public function getSubject(): string
    {
        return HtmlDecode($this->subject);
    }

    public function setSubject(string $value): static
    {
        $this->subject = RemoveXss($value);
        return $this;
    }

    public function getMessage(): string
    {
        return HtmlDecode($this->message);
    }

    public function setMessage(string $value): static
    {
        $this->message = RemoveXss($value);
        return $this;
    }

    public function getCertificateImage(): ?string
    {
        return HtmlDecode($this->certificateImage);
    }

    public function setCertificateImage(?string $value): static
    {
        $this->certificateImage = RemoveXss($value);
        return $this;
    }

    public function getFont(): ?string
    {
        return HtmlDecode($this->font);
    }

    public function setFont(?string $value): static
    {
        $this->font = RemoveXss($value);
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getMFromName(): ?string
    {
        return HtmlDecode($this->mFromName);
    }

    public function setMFromName(?string $value): static
    {
        $this->mFromName = RemoveXss($value);
        return $this;
    }
}
