<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "message_template_admin" table
 */
#[Entity]
#[Table(name: "message_template_admin")]
class MessageTemplateAdmin extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    private int $id;

    #[Column(type: "smallint")]
    private int $grp;

    #[Column(type: "string")]
    private string $description;

    #[Column(type: "text")]
    private string $variables;

    #[Column(type: "string")]
    private string $subject;

    #[Column(name: "status_email_user", type: "integer")]
    private int $statusEmailUser;

    #[Column(name: "email_template_user", type: "text", nullable: true)]
    private ?string $emailTemplateUser;

    #[Column(name: "mail_to_office", type: "string", nullable: true)]
    private ?string $mailToOffice;

    #[Column(name: "status_email_office", type: "integer")]
    private int $statusEmailOffice;

    #[Column(name: "email_template_office", type: "text", nullable: true)]
    private ?string $emailTemplateOffice;

    #[Column(name: "status_sms_user", type: "integer")]
    private int $statusSmsUser;

    #[Column(name: "sms_template_user", type: "string", nullable: true)]
    private ?string $smsTemplateUser;

    #[Column(name: "sms_template_user_id", type: "string", nullable: true)]
    private ?string $smsTemplateUserId;

    #[Column(name: "status_sms_office", type: "integer")]
    private int $statusSmsOffice;

    #[Column(name: "sms_to_office", type: "string", nullable: true)]
    private ?string $smsToOffice;

    #[Column(name: "sms_template_office", type: "string", nullable: true)]
    private ?string $smsTemplateOffice;

    #[Column(name: "sms_template_office_id", type: "string", nullable: true)]
    private ?string $smsTemplateOfficeId;

    #[Column(name: "wa_status_user", type: "integer")]
    private int $waStatusUser;

    #[Column(name: "wa_type_user", type: "integer", nullable: true)]
    private ?int $waTypeUser;

    #[Column(name: "wa_template_user", type: "string", nullable: true)]
    private ?string $waTemplateUser;

    #[Column(name: "wa_status_office", type: "integer", nullable: true)]
    private ?int $waStatusOffice;

    #[Column(name: "wa_type_office", type: "integer", nullable: true)]
    private ?int $waTypeOffice;

    #[Column(name: "wa_to_office", type: "string", nullable: true)]
    private ?string $waToOffice;

    #[Column(name: "wa_template_office", type: "string", nullable: true)]
    private ?string $waTemplateOffice;

    #[Column(name: "wa_id", type: "smallint")]
    private int $waId;

    #[Column(name: "notification_status_user", type: "integer")]
    private int $notificationStatusUser;

    #[Column(name: "notification_template_user", type: "string", nullable: true)]
    private ?string $notificationTemplateUser;

    #[Column(name: "notification_status_office", type: "integer")]
    private int $notificationStatusOffice;

    #[Column(name: "notification_to_office", type: "string", nullable: true)]
    private ?string $notificationToOffice;

    #[Column(name: "notification_template_office", type: "string", nullable: true)]
    private ?string $notificationTemplateOffice;

    #[Column(type: "text", nullable: true)]
    private ?string $code;

    #[Column(type: "integer")]
    private int $visible;

    #[Column(type: "integer")]
    private int $cron;

    #[Column(name: "next_cycle", type: "datetime")]
    private DateTime $nextCycle;

    #[Column(type: "integer")]
    private int $delay;

    #[Column(name: "delay_method", type: "integer")]
    private int $delayMethod;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(name: "operator_admin", type: "smallint")]
    private int $operatorAdmin;

    #[Column(name: "datetime_admin", type: "datetime", nullable: true)]
    private ?DateTime $datetimeAdmin;

    #[Column(name: "company_id", type: "integer")]
    private int $companyId;

    public function __construct()
    {
        $this->statusEmailUser = 0;
        $this->waStatusUser = 0;
        $this->waTypeUser = 0;
        $this->waStatusOffice = 0;
        $this->waTypeOffice = 0;
        $this->waId = 1;
        $this->operator = 0;
        $this->companyId = 1001;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getGrp(): int
    {
        return $this->grp;
    }

    public function setGrp(int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getDescription(): string
    {
        return HtmlDecode($this->description);
    }

    public function setDescription(string $value): static
    {
        $this->description = RemoveXss($value);
        return $this;
    }

    public function getVariables(): string
    {
        return HtmlDecode($this->variables);
    }

    public function setVariables(string $value): static
    {
        $this->variables = RemoveXss($value);
        return $this;
    }

    public function getSubject(): string
    {
        return HtmlDecode($this->subject);
    }

    public function setSubject(string $value): static
    {
        $this->subject = RemoveXss($value);
        return $this;
    }

    public function getStatusEmailUser(): int
    {
        return $this->statusEmailUser;
    }

    public function setStatusEmailUser(int $value): static
    {
        $this->statusEmailUser = $value;
        return $this;
    }

    public function getEmailTemplateUser(): ?string
    {
        return HtmlDecode($this->emailTemplateUser);
    }

    public function setEmailTemplateUser(?string $value): static
    {
        $this->emailTemplateUser = RemoveXss($value);
        return $this;
    }

    public function getMailToOffice(): ?string
    {
        return HtmlDecode($this->mailToOffice);
    }

    public function setMailToOffice(?string $value): static
    {
        $this->mailToOffice = RemoveXss($value);
        return $this;
    }

    public function getStatusEmailOffice(): int
    {
        return $this->statusEmailOffice;
    }

    public function setStatusEmailOffice(int $value): static
    {
        $this->statusEmailOffice = $value;
        return $this;
    }

    public function getEmailTemplateOffice(): ?string
    {
        return HtmlDecode($this->emailTemplateOffice);
    }

    public function setEmailTemplateOffice(?string $value): static
    {
        $this->emailTemplateOffice = RemoveXss($value);
        return $this;
    }

    public function getStatusSmsUser(): int
    {
        return $this->statusSmsUser;
    }

    public function setStatusSmsUser(int $value): static
    {
        $this->statusSmsUser = $value;
        return $this;
    }

    public function getSmsTemplateUser(): ?string
    {
        return HtmlDecode($this->smsTemplateUser);
    }

    public function setSmsTemplateUser(?string $value): static
    {
        $this->smsTemplateUser = RemoveXss($value);
        return $this;
    }

    public function getSmsTemplateUserId(): ?string
    {
        return HtmlDecode($this->smsTemplateUserId);
    }

    public function setSmsTemplateUserId(?string $value): static
    {
        $this->smsTemplateUserId = RemoveXss($value);
        return $this;
    }

    public function getStatusSmsOffice(): int
    {
        return $this->statusSmsOffice;
    }

    public function setStatusSmsOffice(int $value): static
    {
        $this->statusSmsOffice = $value;
        return $this;
    }

    public function getSmsToOffice(): ?string
    {
        return HtmlDecode($this->smsToOffice);
    }

    public function setSmsToOffice(?string $value): static
    {
        $this->smsToOffice = RemoveXss($value);
        return $this;
    }

    public function getSmsTemplateOffice(): ?string
    {
        return HtmlDecode($this->smsTemplateOffice);
    }

    public function setSmsTemplateOffice(?string $value): static
    {
        $this->smsTemplateOffice = RemoveXss($value);
        return $this;
    }

    public function getSmsTemplateOfficeId(): ?string
    {
        return HtmlDecode($this->smsTemplateOfficeId);
    }

    public function setSmsTemplateOfficeId(?string $value): static
    {
        $this->smsTemplateOfficeId = RemoveXss($value);
        return $this;
    }

    public function getWaStatusUser(): int
    {
        return $this->waStatusUser;
    }

    public function setWaStatusUser(int $value): static
    {
        $this->waStatusUser = $value;
        return $this;
    }

    public function getWaTypeUser(): ?int
    {
        return $this->waTypeUser;
    }

    public function setWaTypeUser(?int $value): static
    {
        $this->waTypeUser = $value;
        return $this;
    }

    public function getWaTemplateUser(): ?string
    {
        return HtmlDecode($this->waTemplateUser);
    }

    public function setWaTemplateUser(?string $value): static
    {
        $this->waTemplateUser = RemoveXss($value);
        return $this;
    }

    public function getWaStatusOffice(): ?int
    {
        return $this->waStatusOffice;
    }

    public function setWaStatusOffice(?int $value): static
    {
        $this->waStatusOffice = $value;
        return $this;
    }

    public function getWaTypeOffice(): ?int
    {
        return $this->waTypeOffice;
    }

    public function setWaTypeOffice(?int $value): static
    {
        $this->waTypeOffice = $value;
        return $this;
    }

    public function getWaToOffice(): ?string
    {
        return HtmlDecode($this->waToOffice);
    }

    public function setWaToOffice(?string $value): static
    {
        $this->waToOffice = RemoveXss($value);
        return $this;
    }

    public function getWaTemplateOffice(): ?string
    {
        return HtmlDecode($this->waTemplateOffice);
    }

    public function setWaTemplateOffice(?string $value): static
    {
        $this->waTemplateOffice = RemoveXss($value);
        return $this;
    }

    public function getWaId(): int
    {
        return $this->waId;
    }

    public function setWaId(int $value): static
    {
        $this->waId = $value;
        return $this;
    }

    public function getNotificationStatusUser(): int
    {
        return $this->notificationStatusUser;
    }

    public function setNotificationStatusUser(int $value): static
    {
        $this->notificationStatusUser = $value;
        return $this;
    }

    public function getNotificationTemplateUser(): ?string
    {
        return HtmlDecode($this->notificationTemplateUser);
    }

    public function setNotificationTemplateUser(?string $value): static
    {
        $this->notificationTemplateUser = RemoveXss($value);
        return $this;
    }

    public function getNotificationStatusOffice(): int
    {
        return $this->notificationStatusOffice;
    }

    public function setNotificationStatusOffice(int $value): static
    {
        $this->notificationStatusOffice = $value;
        return $this;
    }

    public function getNotificationToOffice(): ?string
    {
        return HtmlDecode($this->notificationToOffice);
    }

    public function setNotificationToOffice(?string $value): static
    {
        $this->notificationToOffice = RemoveXss($value);
        return $this;
    }

    public function getNotificationTemplateOffice(): ?string
    {
        return HtmlDecode($this->notificationTemplateOffice);
    }

    public function setNotificationTemplateOffice(?string $value): static
    {
        $this->notificationTemplateOffice = RemoveXss($value);
        return $this;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(?string $value): static
    {
        $this->code = $value;
        return $this;
    }

    public function getVisible(): int
    {
        return $this->visible;
    }

    public function setVisible(int $value): static
    {
        $this->visible = $value;
        return $this;
    }

    public function getCron(): int
    {
        return $this->cron;
    }

    public function setCron(int $value): static
    {
        $this->cron = $value;
        return $this;
    }

    public function getNextCycle(): DateTime
    {
        return $this->nextCycle;
    }

    public function setNextCycle(DateTime $value): static
    {
        $this->nextCycle = $value;
        return $this;
    }

    public function getDelay(): int
    {
        return $this->delay;
    }

    public function setDelay(int $value): static
    {
        $this->delay = $value;
        return $this;
    }

    public function getDelayMethod(): int
    {
        return $this->delayMethod;
    }

    public function setDelayMethod(int $value): static
    {
        $this->delayMethod = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getOperatorAdmin(): int
    {
        return $this->operatorAdmin;
    }

    public function setOperatorAdmin(int $value): static
    {
        $this->operatorAdmin = $value;
        return $this;
    }

    public function getDatetimeAdmin(): ?DateTime
    {
        return $this->datetimeAdmin;
    }

    public function setDatetimeAdmin(?DateTime $value): static
    {
        $this->datetimeAdmin = $value;
        return $this;
    }

    public function getCompanyId(): int
    {
        return $this->companyId;
    }

    public function setCompanyId(int $value): static
    {
        $this->companyId = $value;
        return $this;
    }
}
