<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "menus" table
 */
#[Entity]
#[Table(name: "menus")]
class Menu extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string")]
    private string $image;

    #[Column(name: "show_title", type: "integer")]
    private int $showTitle;

    #[Column(name: "page_title", type: "string")]
    private string $pageTitle;

    #[Column(name: "page_url", type: "string")]
    private string $pageUrl;

    #[Column(type: "integer")]
    private int $target;

    #[Column(name: "parent_id", type: "integer")]
    private int $parentId;

    #[Column(name: "show_in_main_menu", type: "integer")]
    private int $showInMainMenu;

    #[Column(type: "integer")]
    private int $status;

    #[Column(name: "order_by", type: "integer", nullable: true)]
    private ?int $orderBy;

    #[Column(name: "mega_menu", type: "integer")]
    private int $megaMenu;

    #[Column(type: "string", nullable: true)]
    private ?string $bgcolor;

    #[Column(type: "integer")]
    private int $submenu;

    #[Column(name: "submenu_code", type: "text", nullable: true)]
    private ?string $submenuCode;

    #[Column(name: "footer_group", type: "string", nullable: true)]
    private ?string $footerGroup;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->showInMainMenu = 0;
        $this->status = 1;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getImage(): string
    {
        return HtmlDecode($this->image);
    }

    public function setImage(string $value): static
    {
        $this->image = RemoveXss($value);
        return $this;
    }

    public function getShowTitle(): int
    {
        return $this->showTitle;
    }

    public function setShowTitle(int $value): static
    {
        $this->showTitle = $value;
        return $this;
    }

    public function getPageTitle(): string
    {
        return HtmlDecode($this->pageTitle);
    }

    public function setPageTitle(string $value): static
    {
        $this->pageTitle = RemoveXss($value);
        return $this;
    }

    public function getPageUrl(): string
    {
        return HtmlDecode($this->pageUrl);
    }

    public function setPageUrl(string $value): static
    {
        $this->pageUrl = RemoveXss($value);
        return $this;
    }

    public function getTarget(): int
    {
        return $this->target;
    }

    public function setTarget(int $value): static
    {
        $this->target = $value;
        return $this;
    }

    public function getParentId(): int
    {
        return $this->parentId;
    }

    public function setParentId(int $value): static
    {
        $this->parentId = $value;
        return $this;
    }

    public function getShowInMainMenu(): int
    {
        return $this->showInMainMenu;
    }

    public function setShowInMainMenu(int $value): static
    {
        $this->showInMainMenu = $value;
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getOrderBy(): ?int
    {
        return $this->orderBy;
    }

    public function setOrderBy(?int $value): static
    {
        $this->orderBy = $value;
        return $this;
    }

    public function getMegaMenu(): int
    {
        return $this->megaMenu;
    }

    public function setMegaMenu(int $value): static
    {
        $this->megaMenu = $value;
        return $this;
    }

    public function getBgcolor(): ?string
    {
        return HtmlDecode($this->bgcolor);
    }

    public function setBgcolor(?string $value): static
    {
        $this->bgcolor = RemoveXss($value);
        return $this;
    }

    public function getSubmenu(): int
    {
        return $this->submenu;
    }

    public function setSubmenu(int $value): static
    {
        $this->submenu = $value;
        return $this;
    }

    public function getSubmenuCode(): ?string
    {
        return HtmlDecode($this->submenuCode);
    }

    public function setSubmenuCode(?string $value): static
    {
        $this->submenuCode = RemoveXss($value);
        return $this;
    }

    public function getFooterGroup(): ?string
    {
        return HtmlDecode($this->footerGroup);
    }

    public function setFooterGroup(?string $value): static
    {
        $this->footerGroup = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
