<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "member_info" table
 */
#[Entity]
#[Table(name: "member_info")]
class MemberInfo extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string", nullable: true)]
    private ?string $type;

    #[Column(type: "string", nullable: true)]
    private ?string $name;

    #[Column(type: "string", nullable: true)]
    private ?string $classification;

    #[Column(type: "string", nullable: true)]
    private ?string $mobile;

    #[Column(type: "string", nullable: true)]
    private ?string $email;

    #[Column(type: "string", nullable: true)]
    private ?string $address;

    #[Column(name: "blood_grp", type: "string", nullable: true)]
    private ?string $bloodGrp;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $dob;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $dom;

    #[Column(name: "join_date", type: "date", nullable: true)]
    private ?DateTime $joinDate;

    #[Column(name: "spouse_name", type: "string", nullable: true)]
    private ?string $spouseName;

    #[Column(name: "children_name", type: "string", nullable: true)]
    private ?string $childrenName;

    #[Column(type: "string", nullable: true)]
    private ?string $image;

    #[Column(type: "string", nullable: true)]
    private ?string $remakrs;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(name: "couple_image", type: "string", nullable: true)]
    private ?string $coupleImage;

    public function __construct()
    {
        $this->type = 'General';
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getType(): ?string
    {
        return HtmlDecode($this->type);
    }

    public function setType(?string $value): static
    {
        $this->type = RemoveXss($value);
        return $this;
    }

    public function getName(): ?string
    {
        return HtmlDecode($this->name);
    }

    public function setName(?string $value): static
    {
        $this->name = RemoveXss($value);
        return $this;
    }

    public function getClassification(): ?string
    {
        return HtmlDecode($this->classification);
    }

    public function setClassification(?string $value): static
    {
        $this->classification = RemoveXss($value);
        return $this;
    }

    public function getMobile(): ?string
    {
        return HtmlDecode($this->mobile);
    }

    public function setMobile(?string $value): static
    {
        $this->mobile = RemoveXss($value);
        return $this;
    }

    public function getEmail(): ?string
    {
        return HtmlDecode($this->email);
    }

    public function setEmail(?string $value): static
    {
        $this->email = RemoveXss($value);
        return $this;
    }

    public function getAddress(): ?string
    {
        return HtmlDecode($this->address);
    }

    public function setAddress(?string $value): static
    {
        $this->address = RemoveXss($value);
        return $this;
    }

    public function getBloodGrp(): ?string
    {
        return HtmlDecode($this->bloodGrp);
    }

    public function setBloodGrp(?string $value): static
    {
        $this->bloodGrp = RemoveXss($value);
        return $this;
    }

    public function getDob(): ?DateTime
    {
        return $this->dob;
    }

    public function setDob(?DateTime $value): static
    {
        $this->dob = $value;
        return $this;
    }

    public function getDom(): ?DateTime
    {
        return $this->dom;
    }

    public function setDom(?DateTime $value): static
    {
        $this->dom = $value;
        return $this;
    }

    public function getJoinDate(): ?DateTime
    {
        return $this->joinDate;
    }

    public function setJoinDate(?DateTime $value): static
    {
        $this->joinDate = $value;
        return $this;
    }

    public function getSpouseName(): ?string
    {
        return HtmlDecode($this->spouseName);
    }

    public function setSpouseName(?string $value): static
    {
        $this->spouseName = RemoveXss($value);
        return $this;
    }

    public function getChildrenName(): ?string
    {
        return HtmlDecode($this->childrenName);
    }

    public function setChildrenName(?string $value): static
    {
        $this->childrenName = RemoveXss($value);
        return $this;
    }

    public function getImage(): ?string
    {
        return HtmlDecode($this->image);
    }

    public function setImage(?string $value): static
    {
        $this->image = RemoveXss($value);
        return $this;
    }

    public function getRemakrs(): ?string
    {
        return HtmlDecode($this->remakrs);
    }

    public function setRemakrs(?string $value): static
    {
        $this->remakrs = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getCoupleImage(): ?string
    {
        return HtmlDecode($this->coupleImage);
    }

    public function setCoupleImage(?string $value): static
    {
        $this->coupleImage = RemoveXss($value);
        return $this;
    }
}
