<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "material_required_weekly_loomplan_short" table
 */
#[Entity]
#[Table(name: "material_required_weekly_loomplan_short")]
class MaterialRequiredWeeklyLoomplanShort extends AbstractEntity
{
    #[Column(type: "smallint")]
    private int $godown;

    #[Column(type: "string")]
    private string $week;

    #[Column(type: "smallint", nullable: true)]
    private ?int $rid;

    #[Column(name: "packing_type", type: "smallint", nullable: true)]
    private ?int $packingType;

    #[Column(type: "float", nullable: true)]
    private ?float $required;

    #[Column(type: "decimal")]
    private string $stock;

    #[Column(name: "stock_all", type: "decimal", nullable: true)]
    private ?string $stockAll;

    #[Column(type: "float", nullable: true)]
    private ?float $short;

    public function __construct()
    {
        $this->week = "0";
        $this->stock = "0.00";
    }

    public function getGodown(): int
    {
        return $this->godown;
    }

    public function setGodown(int $value): static
    {
        $this->godown = $value;
        return $this;
    }

    public function getWeek(): string
    {
        return HtmlDecode($this->week);
    }

    public function setWeek(string $value): static
    {
        $this->week = RemoveXss($value);
        return $this;
    }

    public function getRid(): ?int
    {
        return $this->rid;
    }

    public function setRid(?int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getPackingType(): ?int
    {
        return $this->packingType;
    }

    public function setPackingType(?int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getRequired(): ?float
    {
        return $this->required;
    }

    public function setRequired(?float $value): static
    {
        $this->required = $value;
        return $this;
    }

    public function getStock(): string
    {
        return $this->stock;
    }

    public function setStock(string $value): static
    {
        $this->stock = $value;
        return $this;
    }

    public function getStockAll(): ?string
    {
        return $this->stockAll;
    }

    public function setStockAll(?string $value): static
    {
        $this->stockAll = $value;
        return $this;
    }

    public function getShort(): ?float
    {
        return $this->short;
    }

    public function setShort(?float $value): static
    {
        $this->short = $value;
        return $this;
    }
}
