<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "material_required_weekly" table
 */
#[Entity]
#[Table(name: "material_required_weekly")]
class MaterialRequiredWeekly extends AbstractEntity
{
    #[Column(type: "smallint", nullable: true)]
    private ?int $week;

    #[Column(type: "smallint", nullable: true)]
    private ?int $rid;

    #[Column(type: "string", nullable: true)]
    private ?string $packing;

    #[Column(type: "decimal")]
    private string $stock;

    #[Column(type: "float", nullable: true)]
    private ?float $required;

    public function __construct()
    {
        $this->stock = "0.000";
    }

    public function getWeek(): ?int
    {
        return $this->week;
    }

    public function setWeek(?int $value): static
    {
        $this->week = $value;
        return $this;
    }

    public function getRid(): ?int
    {
        return $this->rid;
    }

    public function setRid(?int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getPacking(): ?string
    {
        return HtmlDecode($this->packing);
    }

    public function setPacking(?string $value): static
    {
        $this->packing = RemoveXss($value);
        return $this;
    }

    public function getStock(): string
    {
        return $this->stock;
    }

    public function setStock(string $value): static
    {
        $this->stock = $value;
        return $this;
    }

    public function getRequired(): ?float
    {
        return $this->required;
    }

    public function setRequired(?float $value): static
    {
        $this->required = $value;
        return $this;
    }
}
