<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "material_required_processing_outside" table
 */
#[Entity]
#[Table(name: "material_required_processing_outside")]
class MaterialRequiredProcessingOutside extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "integer")]
    private int $poid;

    #[Column(type: "integer", nullable: true)]
    private ?int $location;

    #[Column(type: "smallint")]
    private int $week;

    #[Column(type: "smallint", nullable: true)]
    private ?int $po;

    #[Column(name: "buyer_id", type: "integer")]
    private int $buyerId;

    #[Column(type: "smallint")]
    private int $grp;

    #[Column(name: "s_grp", type: "smallint")]
    private int $sGrp;

    #[Column(type: "smallint")]
    private int $product;

    #[Column(name: "product_id", type: "smallint", nullable: true)]
    private ?int $productId;

    #[Column(name: "batch_no", type: "smallint")]
    private int $batchNo;

    #[Column(type: "decimal", nullable: true)]
    private ?string $quantity;

    #[Column(name: "size_cm", type: "string", nullable: true)]
    private ?string $sizeCm;

    #[Column(type: "decimal", nullable: true)]
    private ?string $sqm;

    #[Column(name: "t_sqm", type: "decimal", nullable: true)]
    private ?string $tSqm;

    #[Column(name: "req_material_grp", type: "smallint", nullable: true)]
    private ?int $reqMaterialGrp;

    #[Column(name: "req_material_sgrp", type: "smallint", nullable: true)]
    private ?int $reqMaterialSgrp;

    #[Column(name: "req_material_product", type: "smallint", nullable: true)]
    private ?int $reqMaterialProduct;

    #[Column(name: "req_material_packing", type: "smallint")]
    private int $reqMaterialPacking;

    #[Column(name: "req_material_rid", type: "smallint", nullable: true)]
    private ?int $reqMaterialRid;

    #[Column(name: "req_material_qty", type: "decimal")]
    private string $reqMaterialQty;

    #[Column(name: "issued_qty", type: "decimal", nullable: true)]
    private ?string $issuedQty;

    #[Column(name: "issued_pkt", type: "decimal")]
    private string $issuedPkt;

    #[Column(name: "lot_no", type: "string", nullable: true)]
    private ?string $lotNo;

    #[Column(type: "decimal")]
    private string $stock;

    #[Column(type: "decimal")]
    private string $short;

    #[Column(type: "string", nullable: true)]
    private ?string $unit;

    #[Column(name: "material_qty", type: "decimal", nullable: true)]
    private ?string $materialQty;

    #[Column(type: "integer", nullable: true)]
    private ?int $method;

    #[Column(name: "despatch_week", type: "smallint", nullable: true)]
    private ?int $despatchWeek;

    #[Column(name: "despatch_date", type: "date")]
    private DateTime $despatchDate;

    #[Column(name: "production_plan", type: "smallint", nullable: true)]
    private ?int $productionPlan;

    #[Column(type: "text")]
    private string $remarks;

    #[Column(type: "integer")]
    private int $updated;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(name: "issue_to", type: "integer")]
    private int $issueTo;

    #[Column(name: "jc_no", type: "integer", nullable: true)]
    private ?int $jcNo;

    #[Column(name: "company_id", type: "integer", nullable: true)]
    private ?int $companyId;

    public function __construct()
    {
        $this->week = 0;
        $this->grp = 3;
        $this->issuedPkt = "0.00";
        $this->stock = "0.000";
        $this->updated = 0;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getPoid(): int
    {
        return $this->poid;
    }

    public function setPoid(int $value): static
    {
        $this->poid = $value;
        return $this;
    }

    public function getLocation(): ?int
    {
        return $this->location;
    }

    public function setLocation(?int $value): static
    {
        $this->location = $value;
        return $this;
    }

    public function getWeek(): int
    {
        return $this->week;
    }

    public function setWeek(int $value): static
    {
        $this->week = $value;
        return $this;
    }

    public function getPo(): ?int
    {
        return $this->po;
    }

    public function setPo(?int $value): static
    {
        $this->po = $value;
        return $this;
    }

    public function getBuyerId(): int
    {
        return $this->buyerId;
    }

    public function setBuyerId(int $value): static
    {
        $this->buyerId = $value;
        return $this;
    }

    public function getGrp(): int
    {
        return $this->grp;
    }

    public function setGrp(int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): int
    {
        return $this->sGrp;
    }

    public function setSGrp(int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getProduct(): int
    {
        return $this->product;
    }

    public function setProduct(int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getProductId(): ?int
    {
        return $this->productId;
    }

    public function setProductId(?int $value): static
    {
        $this->productId = $value;
        return $this;
    }

    public function getBatchNo(): int
    {
        return $this->batchNo;
    }

    public function setBatchNo(int $value): static
    {
        $this->batchNo = $value;
        return $this;
    }

    public function getQuantity(): ?string
    {
        return $this->quantity;
    }

    public function setQuantity(?string $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getSizeCm(): ?string
    {
        return HtmlDecode($this->sizeCm);
    }

    public function setSizeCm(?string $value): static
    {
        $this->sizeCm = RemoveXss($value);
        return $this;
    }

    public function getSqm(): ?string
    {
        return $this->sqm;
    }

    public function setSqm(?string $value): static
    {
        $this->sqm = $value;
        return $this;
    }

    public function getTSqm(): ?string
    {
        return $this->tSqm;
    }

    public function setTSqm(?string $value): static
    {
        $this->tSqm = $value;
        return $this;
    }

    public function getReqMaterialGrp(): ?int
    {
        return $this->reqMaterialGrp;
    }

    public function setReqMaterialGrp(?int $value): static
    {
        $this->reqMaterialGrp = $value;
        return $this;
    }

    public function getReqMaterialSgrp(): ?int
    {
        return $this->reqMaterialSgrp;
    }

    public function setReqMaterialSgrp(?int $value): static
    {
        $this->reqMaterialSgrp = $value;
        return $this;
    }

    public function getReqMaterialProduct(): ?int
    {
        return $this->reqMaterialProduct;
    }

    public function setReqMaterialProduct(?int $value): static
    {
        $this->reqMaterialProduct = $value;
        return $this;
    }

    public function getReqMaterialPacking(): int
    {
        return $this->reqMaterialPacking;
    }

    public function setReqMaterialPacking(int $value): static
    {
        $this->reqMaterialPacking = $value;
        return $this;
    }

    public function getReqMaterialRid(): ?int
    {
        return $this->reqMaterialRid;
    }

    public function setReqMaterialRid(?int $value): static
    {
        $this->reqMaterialRid = $value;
        return $this;
    }

    public function getReqMaterialQty(): string
    {
        return $this->reqMaterialQty;
    }

    public function setReqMaterialQty(string $value): static
    {
        $this->reqMaterialQty = $value;
        return $this;
    }

    public function getIssuedQty(): ?string
    {
        return $this->issuedQty;
    }

    public function setIssuedQty(?string $value): static
    {
        $this->issuedQty = $value;
        return $this;
    }

    public function getIssuedPkt(): string
    {
        return $this->issuedPkt;
    }

    public function setIssuedPkt(string $value): static
    {
        $this->issuedPkt = $value;
        return $this;
    }

    public function getLotNo(): ?string
    {
        return HtmlDecode($this->lotNo);
    }

    public function setLotNo(?string $value): static
    {
        $this->lotNo = RemoveXss($value);
        return $this;
    }

    public function getStock(): string
    {
        return $this->stock;
    }

    public function setStock(string $value): static
    {
        $this->stock = $value;
        return $this;
    }

    public function getShort(): string
    {
        return $this->short;
    }

    public function setShort(string $value): static
    {
        $this->short = $value;
        return $this;
    }

    public function getUnit(): ?string
    {
        return HtmlDecode($this->unit);
    }

    public function setUnit(?string $value): static
    {
        $this->unit = RemoveXss($value);
        return $this;
    }

    public function getMaterialQty(): ?string
    {
        return $this->materialQty;
    }

    public function setMaterialQty(?string $value): static
    {
        $this->materialQty = $value;
        return $this;
    }

    public function getMethod(): ?int
    {
        return $this->method;
    }

    public function setMethod(?int $value): static
    {
        $this->method = $value;
        return $this;
    }

    public function getDespatchWeek(): ?int
    {
        return $this->despatchWeek;
    }

    public function setDespatchWeek(?int $value): static
    {
        $this->despatchWeek = $value;
        return $this;
    }

    public function getDespatchDate(): DateTime
    {
        return $this->despatchDate;
    }

    public function setDespatchDate(DateTime $value): static
    {
        $this->despatchDate = $value;
        return $this;
    }

    public function getProductionPlan(): ?int
    {
        return $this->productionPlan;
    }

    public function setProductionPlan(?int $value): static
    {
        $this->productionPlan = $value;
        return $this;
    }

    public function getRemarks(): string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getUpdated(): int
    {
        return $this->updated;
    }

    public function setUpdated(int $value): static
    {
        $this->updated = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getIssueTo(): int
    {
        return $this->issueTo;
    }

    public function setIssueTo(int $value): static
    {
        $this->issueTo = $value;
        return $this;
    }

    public function getJcNo(): ?int
    {
        return $this->jcNo;
    }

    public function setJcNo(?int $value): static
    {
        $this->jcNo = $value;
        return $this;
    }

    public function getCompanyId(): ?int
    {
        return $this->companyId;
    }

    public function setCompanyId(?int $value): static
    {
        $this->companyId = $value;
        return $this;
    }
}
