<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "material_required_monthly_cross_company" table
 */
#[Entity]
#[Table(name: "material_required_monthly_cross_company")]
class MaterialRequiredMonthlyCrossCompany extends AbstractEntity
{
    #[Column(type: "string", nullable: true)]
    private ?string $month;

    #[Column(type: "integer", nullable: true)]
    private ?int $buyer;

    #[Column(name: "processed_by", type: "integer", nullable: true)]
    private ?int $processedBy;

    #[Column(name: "design_id", type: "string", nullable: true)]
    private ?string $designId;

    #[Column(name: "size_cm", type: "string")]
    private string $sizeCm;

    #[Column(type: "decimal", nullable: true)]
    private ?string $sqm;

    #[Column(name: "req_material_rid", type: "smallint", nullable: true)]
    private ?int $reqMaterialRid;

    #[Column(name: "req_material_packing", type: "smallint", nullable: true)]
    private ?int $reqMaterialPacking;

    #[Column(name: "req_material_qty", type: "float", nullable: true)]
    private ?float $reqMaterialQty;

    #[Column(type: "text", nullable: true)]
    private ?string $barcode;

    #[Column(type: "text", nullable: true)]
    private ?string $no;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    public function __construct()
    {
        $this->no = "0";
    }

    public function getMonth(): ?string
    {
        return HtmlDecode($this->month);
    }

    public function setMonth(?string $value): static
    {
        $this->month = RemoveXss($value);
        return $this;
    }

    public function getBuyer(): ?int
    {
        return $this->buyer;
    }

    public function setBuyer(?int $value): static
    {
        $this->buyer = $value;
        return $this;
    }

    public function getProcessedBy(): ?int
    {
        return $this->processedBy;
    }

    public function setProcessedBy(?int $value): static
    {
        $this->processedBy = $value;
        return $this;
    }

    public function getDesignId(): ?string
    {
        return HtmlDecode($this->designId);
    }

    public function setDesignId(?string $value): static
    {
        $this->designId = RemoveXss($value);
        return $this;
    }

    public function getSizeCm(): string
    {
        return HtmlDecode($this->sizeCm);
    }

    public function setSizeCm(string $value): static
    {
        $this->sizeCm = RemoveXss($value);
        return $this;
    }

    public function getSqm(): ?string
    {
        return $this->sqm;
    }

    public function setSqm(?string $value): static
    {
        $this->sqm = $value;
        return $this;
    }

    public function getReqMaterialRid(): ?int
    {
        return $this->reqMaterialRid;
    }

    public function setReqMaterialRid(?int $value): static
    {
        $this->reqMaterialRid = $value;
        return $this;
    }

    public function getReqMaterialPacking(): ?int
    {
        return $this->reqMaterialPacking;
    }

    public function setReqMaterialPacking(?int $value): static
    {
        $this->reqMaterialPacking = $value;
        return $this;
    }

    public function getReqMaterialQty(): ?float
    {
        return $this->reqMaterialQty;
    }

    public function setReqMaterialQty(?float $value): static
    {
        $this->reqMaterialQty = $value;
        return $this;
    }

    public function getBarcode(): ?string
    {
        return HtmlDecode($this->barcode);
    }

    public function setBarcode(?string $value): static
    {
        $this->barcode = RemoveXss($value);
        return $this;
    }

    public function getNo(): ?string
    {
        return HtmlDecode($this->no);
    }

    public function setNo(?string $value): static
    {
        $this->no = RemoveXss($value);
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
