<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "material_required_export" table
 */
#[Entity]
#[Table(name: "material_required_export")]
class MaterialRequiredExport extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer")]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "weaving_works", type: "smallint", nullable: true)]
    private ?int $weavingWorks;

    #[Column(type: "smallint")]
    private int $week;

    #[Column(type: "integer", nullable: true)]
    private ?int $po;

    #[Column(name: "buyer_id", type: "integer")]
    private int $buyerId;

    #[Column(name: "product_id", type: "smallint", nullable: true)]
    private ?int $productId;

    #[Column(name: "req_material_rid", type: "smallint", nullable: true)]
    private ?int $reqMaterialRid;

    #[Column(name: "req_material_qty", type: "decimal")]
    private string $reqMaterialQty;

    #[Column(name: "req_material_packing", type: "smallint")]
    private int $reqMaterialPacking;

    #[Column(name: "batch_no", type: "smallint")]
    private int $batchNo;

    #[Column(type: "smallint", nullable: true)]
    private ?int $quantity;

    #[Column(name: "Size_wl", type: "string", nullable: true)]
    private ?string $sizeWl;

    #[Column(type: "decimal", nullable: true)]
    private ?string $sqm;

    #[Column(name: "t_sqm", type: "decimal", nullable: true)]
    private ?string $tSqm;

    #[Column(type: "string", nullable: true)]
    private ?string $unit;

    #[Column(name: "material_qty", type: "decimal", nullable: true)]
    private ?string $materialQty;

    #[Column(type: "integer", nullable: true)]
    private ?int $method;

    #[Column(name: "despatch_week", type: "smallint", nullable: true)]
    private ?int $despatchWeek;

    #[Column(name: "production_plan", type: "smallint", nullable: true)]
    private ?int $productionPlan;

    public function __construct()
    {
        $this->week = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getWeavingWorks(): ?int
    {
        return $this->weavingWorks;
    }

    public function setWeavingWorks(?int $value): static
    {
        $this->weavingWorks = $value;
        return $this;
    }

    public function getWeek(): int
    {
        return $this->week;
    }

    public function setWeek(int $value): static
    {
        $this->week = $value;
        return $this;
    }

    public function getPo(): ?int
    {
        return $this->po;
    }

    public function setPo(?int $value): static
    {
        $this->po = $value;
        return $this;
    }

    public function getBuyerId(): int
    {
        return $this->buyerId;
    }

    public function setBuyerId(int $value): static
    {
        $this->buyerId = $value;
        return $this;
    }

    public function getProductId(): ?int
    {
        return $this->productId;
    }

    public function setProductId(?int $value): static
    {
        $this->productId = $value;
        return $this;
    }

    public function getReqMaterialRid(): ?int
    {
        return $this->reqMaterialRid;
    }

    public function setReqMaterialRid(?int $value): static
    {
        $this->reqMaterialRid = $value;
        return $this;
    }

    public function getReqMaterialQty(): string
    {
        return $this->reqMaterialQty;
    }

    public function setReqMaterialQty(string $value): static
    {
        $this->reqMaterialQty = $value;
        return $this;
    }

    public function getReqMaterialPacking(): int
    {
        return $this->reqMaterialPacking;
    }

    public function setReqMaterialPacking(int $value): static
    {
        $this->reqMaterialPacking = $value;
        return $this;
    }

    public function getBatchNo(): int
    {
        return $this->batchNo;
    }

    public function setBatchNo(int $value): static
    {
        $this->batchNo = $value;
        return $this;
    }

    public function getQuantity(): ?int
    {
        return $this->quantity;
    }

    public function setQuantity(?int $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getSizeWl(): ?string
    {
        return HtmlDecode($this->sizeWl);
    }

    public function setSizeWl(?string $value): static
    {
        $this->sizeWl = RemoveXss($value);
        return $this;
    }

    public function getSqm(): ?string
    {
        return $this->sqm;
    }

    public function setSqm(?string $value): static
    {
        $this->sqm = $value;
        return $this;
    }

    public function getTSqm(): ?string
    {
        return $this->tSqm;
    }

    public function setTSqm(?string $value): static
    {
        $this->tSqm = $value;
        return $this;
    }

    public function getUnit(): ?string
    {
        return HtmlDecode($this->unit);
    }

    public function setUnit(?string $value): static
    {
        $this->unit = RemoveXss($value);
        return $this;
    }

    public function getMaterialQty(): ?string
    {
        return $this->materialQty;
    }

    public function setMaterialQty(?string $value): static
    {
        $this->materialQty = $value;
        return $this;
    }

    public function getMethod(): ?int
    {
        return $this->method;
    }

    public function setMethod(?int $value): static
    {
        $this->method = $value;
        return $this;
    }

    public function getDespatchWeek(): ?int
    {
        return $this->despatchWeek;
    }

    public function setDespatchWeek(?int $value): static
    {
        $this->despatchWeek = $value;
        return $this;
    }

    public function getProductionPlan(): ?int
    {
        return $this->productionPlan;
    }

    public function setProductionPlan(?int $value): static
    {
        $this->productionPlan = $value;
        return $this;
    }
}
