<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "material_out_old" table
 */
#[Entity]
#[Table(name: "material_out_old")]
class MaterialOutOld extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $grp;

    #[Column(name: "s_grp", type: "smallint")]
    private int $sGrp;

    #[Column(type: "smallint")]
    private int $product;

    #[Column(type: "smallint")]
    private int $rid;

    #[Column(name: "rid_1", type: "string", nullable: true)]
    private ?string $rid1;

    #[Column(name: "rid_name", type: "string", nullable: true)]
    private ?string $ridName;

    #[Column(type: "decimal", nullable: true)]
    private ?string $packets;

    #[Column(name: "packing_type", type: "smallint")]
    private int $packingType;

    #[Column(name: "quantity_avg_act", type: "integer", nullable: true)]
    private ?int $quantityAvgAct;

    #[Column(name: "quantity_sub", type: "decimal", nullable: true)]
    private ?string $quantitySub;

    #[Column(type: "decimal", nullable: true)]
    private ?string $quantity;

    #[Column(type: "integer", nullable: true)]
    private ?int $process;

    #[Column(name: "process_type", type: "smallint", nullable: true)]
    private ?int $processType;

    #[Column(name: "lot_no", type: "string", nullable: true)]
    private ?string $lotNo;

    #[Column(type: "integer", nullable: true)]
    private ?int $barcode;

    #[Column(name: "tmp_lot", type: "decimal", nullable: true)]
    private ?string $tmpLot;

    #[Column(type: "float", nullable: true)]
    private ?float $price;

    #[Column(name: "cart_amount", type: "float", nullable: true)]
    private ?float $cartAmount;

    #[Column(name: "other_amount", type: "float", nullable: true)]
    private ?float $otherAmount;

    #[Column(type: "float", nullable: true)]
    private ?float $amount;

    #[Column(name: "tax_amount", type: "float", nullable: true)]
    private ?float $taxAmount;

    #[Column(name: "total_amount", type: "float", nullable: true)]
    private ?float $totalAmount;

    #[Column(name: "tax_percent", type: "float", nullable: true)]
    private ?float $taxPercent;

    #[Column(name: "hsn_code", type: "float", nullable: true)]
    private ?float $hsnCode;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(name: "company_id", type: "integer", nullable: true)]
    private ?int $companyId;

    #[Column(type: "integer", nullable: true)]
    private ?int $godown;

    #[Column(name: "godown_po", type: "integer", nullable: true)]
    private ?int $godownPo;

    #[Column(name: "issue_to", type: "integer", nullable: true)]
    private ?int $issueTo;

    #[Column(name: "issue_to_unit", type: "smallint", nullable: true)]
    private ?int $issueToUnit;

    #[Column(name: "gp_no", type: "smallint", nullable: true)]
    private ?int $gpNo;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $dated;

    #[Column(name: "jc_no", type: "string", nullable: true)]
    private ?string $jcNo;

    #[Column(type: "smallint", nullable: true)]
    private ?int $po;

    #[Column(type: "string", nullable: true)]
    private ?string $print;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "integer", nullable: true)]
    private ?int $status;

    #[Column(type: "string", nullable: true)]
    private ?string $uploads;

    #[Column(name: "cart_ref", type: "integer", nullable: true)]
    private ?int $cartRef;

    public function __construct()
    {
        $this->grp = (isset($_GET['GRP']))  ? $_GET['GRP'] :( (isset($_COOKIE['GRP']))  ? $_COOKIE['GRP'] : '');
        $this->sGrp = (isset($_GET['SGRP']))  ? $_GET['SGRP'] : ((isset($_COOKIE['SGRP']))  ? $_COOKIE['SGRP'] : '');
        $this->product = (isset($_GET['PR']))  ? $_GET['PR'] : ((isset($_COOKIE['PR']))  ? $_COOKIE['PR'] : '');
        $this->rid = (isset($_GET['RID']))  ? $_GET['RID'] : ((isset($_COOKIE['RID']))  ? $_COOKIE['RID'] : '');
        $this->rid1 = (isset($_GET['RID1']))  ? $_GET['RID1'] : ((isset($_COOKIE['RID1']))  ? $_COOKIE['RID1'] : '');
        $this->packets = (isset($_GET['PKT']))  ? $_GET['PKT'] : '';
        $this->packingType = (isset($_GET['PKG']))  ? $_GET['PKG'] : ((isset($_COOKIE['PKG']))  ? $_COOKIE['PKG'] : 3);
        $this->quantityAvgAct = 0;
        $this->quantity = (isset($_GET['QTY']))  ? $_GET['QTY'] : 0;
        $this->process = (isset($_GET['PRO']))  ? $_GET['PRO'] : '';
        $this->lotNo = (isset($_GET['LNO']))  ? $_GET['LNO'] : ((isset($_COOKIE['LNO']))  ? $_COOKIE['LNO'] : '');
        $this->price = (isset($_GET['PRICE']))  ? $_GET['PRICE'] : '';
        $this->cartAmount = 0;
        $this->otherAmount = 0;
        $this->operator = 0;
        $this->godown = (isset($_GET['GODOWN']))  ? $_GET['GODOWN'] : ((isset($_COOKIE['GODOWN']))  ? $_COOKIE['GODOWN'] : '');
        $this->issueTo = (isset($_GET['BUY']))  ? $_GET['BUY'] : '';
        $this->jcNo = (isset($_GET['JC']))  ? $_GET['JC'] : '0';
        $this->status = 1;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getGrp(): int
    {
        return $this->grp;
    }

    public function setGrp(int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): int
    {
        return $this->sGrp;
    }

    public function setSGrp(int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getProduct(): int
    {
        return $this->product;
    }

    public function setProduct(int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getRid(): int
    {
        return $this->rid;
    }

    public function setRid(int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getRid1(): ?string
    {
        return HtmlDecode($this->rid1);
    }

    public function setRid1(?string $value): static
    {
        $this->rid1 = RemoveXss($value);
        return $this;
    }

    public function getRidName(): ?string
    {
        return HtmlDecode($this->ridName);
    }

    public function setRidName(?string $value): static
    {
        $this->ridName = RemoveXss($value);
        return $this;
    }

    public function getPackets(): ?string
    {
        return $this->packets;
    }

    public function setPackets(?string $value): static
    {
        $this->packets = $value;
        return $this;
    }

    public function getPackingType(): int
    {
        return $this->packingType;
    }

    public function setPackingType(int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getQuantityAvgAct(): ?int
    {
        return $this->quantityAvgAct;
    }

    public function setQuantityAvgAct(?int $value): static
    {
        $this->quantityAvgAct = $value;
        return $this;
    }

    public function getQuantitySub(): ?string
    {
        return $this->quantitySub;
    }

    public function setQuantitySub(?string $value): static
    {
        $this->quantitySub = $value;
        return $this;
    }

    public function getQuantity(): ?string
    {
        return $this->quantity;
    }

    public function setQuantity(?string $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getProcess(): ?int
    {
        return $this->process;
    }

    public function setProcess(?int $value): static
    {
        $this->process = $value;
        return $this;
    }

    public function getProcessType(): ?int
    {
        return $this->processType;
    }

    public function setProcessType(?int $value): static
    {
        $this->processType = $value;
        return $this;
    }

    public function getLotNo(): ?string
    {
        return HtmlDecode($this->lotNo);
    }

    public function setLotNo(?string $value): static
    {
        $this->lotNo = RemoveXss($value);
        return $this;
    }

    public function getBarcode(): ?int
    {
        return $this->barcode;
    }

    public function setBarcode(?int $value): static
    {
        $this->barcode = $value;
        return $this;
    }

    public function getTmpLot(): ?string
    {
        return $this->tmpLot;
    }

    public function setTmpLot(?string $value): static
    {
        $this->tmpLot = $value;
        return $this;
    }

    public function getPrice(): ?float
    {
        return $this->price;
    }

    public function setPrice(?float $value): static
    {
        $this->price = $value;
        return $this;
    }

    public function getCartAmount(): ?float
    {
        return $this->cartAmount;
    }

    public function setCartAmount(?float $value): static
    {
        $this->cartAmount = $value;
        return $this;
    }

    public function getOtherAmount(): ?float
    {
        return $this->otherAmount;
    }

    public function setOtherAmount(?float $value): static
    {
        $this->otherAmount = $value;
        return $this;
    }

    public function getAmount(): ?float
    {
        return $this->amount;
    }

    public function setAmount(?float $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getTaxAmount(): ?float
    {
        return $this->taxAmount;
    }

    public function setTaxAmount(?float $value): static
    {
        $this->taxAmount = $value;
        return $this;
    }

    public function getTotalAmount(): ?float
    {
        return $this->totalAmount;
    }

    public function setTotalAmount(?float $value): static
    {
        $this->totalAmount = $value;
        return $this;
    }

    public function getTaxPercent(): ?float
    {
        return $this->taxPercent;
    }

    public function setTaxPercent(?float $value): static
    {
        $this->taxPercent = $value;
        return $this;
    }

    public function getHsnCode(): ?float
    {
        return $this->hsnCode;
    }

    public function setHsnCode(?float $value): static
    {
        $this->hsnCode = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getCompanyId(): ?int
    {
        return $this->companyId;
    }

    public function setCompanyId(?int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getGodown(): ?int
    {
        return $this->godown;
    }

    public function setGodown(?int $value): static
    {
        $this->godown = $value;
        return $this;
    }

    public function getGodownPo(): ?int
    {
        return $this->godownPo;
    }

    public function setGodownPo(?int $value): static
    {
        $this->godownPo = $value;
        return $this;
    }

    public function getIssueTo(): ?int
    {
        return $this->issueTo;
    }

    public function setIssueTo(?int $value): static
    {
        $this->issueTo = $value;
        return $this;
    }

    public function getIssueToUnit(): ?int
    {
        return $this->issueToUnit;
    }

    public function setIssueToUnit(?int $value): static
    {
        $this->issueToUnit = $value;
        return $this;
    }

    public function getGpNo(): ?int
    {
        return $this->gpNo;
    }

    public function setGpNo(?int $value): static
    {
        $this->gpNo = $value;
        return $this;
    }

    public function getDated(): ?DateTime
    {
        return $this->dated;
    }

    public function setDated(?DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }

    public function getJcNo(): ?string
    {
        return HtmlDecode($this->jcNo);
    }

    public function setJcNo(?string $value): static
    {
        $this->jcNo = RemoveXss($value);
        return $this;
    }

    public function getPo(): ?int
    {
        return $this->po;
    }

    public function setPo(?int $value): static
    {
        $this->po = $value;
        return $this;
    }

    public function getPrint(): ?string
    {
        return HtmlDecode($this->print);
    }

    public function setPrint(?string $value): static
    {
        $this->print = RemoveXss($value);
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getUploads(): ?string
    {
        return HtmlDecode($this->uploads);
    }

    public function setUploads(?string $value): static
    {
        $this->uploads = RemoveXss($value);
        return $this;
    }

    public function getCartRef(): ?int
    {
        return $this->cartRef;
    }

    public function setCartRef(?int $value): static
    {
        $this->cartRef = $value;
        return $this;
    }
}
