<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "material_out_bc" table
 */
#[Entity]
#[Table(name: "material_out_bc")]
class MaterialOutBc extends AbstractEntity
{
    #[Column(type: "integer", nullable: true)]
    private ?int $process;

    #[Column(name: "issue_to", type: "integer", nullable: true)]
    private ?int $issueTo;

    #[Column(type: "integer", nullable: true)]
    private ?int $godown;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $dated;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "integer", nullable: true)]
    private ?int $barcode;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    public function __construct()
    {
        $this->process = (isset($_GET['Process']))  ? $_GET['Process'] : ((isset($_COOKIE['Process']))  ? $_COOKIE['Process'] : 101);
        $this->issueTo = (isset($_GET['BUY']))  ? $_GET['BUY'] : '';
        $this->godown = (isset($_GET['GODOWN']))  ? $_GET['GODOWN'] : ((isset($_COOKIE['GODOWN']))  ? $_COOKIE['GODOWN'] : 1);
        $this->operator = 0;
    }

    public function getProcess(): ?int
    {
        return $this->process;
    }

    public function setProcess(?int $value): static
    {
        $this->process = $value;
        return $this;
    }

    public function getIssueTo(): ?int
    {
        return $this->issueTo;
    }

    public function setIssueTo(?int $value): static
    {
        $this->issueTo = $value;
        return $this;
    }

    public function getGodown(): ?int
    {
        return $this->godown;
    }

    public function setGodown(?int $value): static
    {
        $this->godown = $value;
        return $this;
    }

    public function getDated(): ?DateTime
    {
        return $this->dated;
    }

    public function setDated(?DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getBarcode(): ?int
    {
        return $this->barcode;
    }

    public function setBarcode(?int $value): static
    {
        $this->barcode = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
