<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "material order" table
 */
#[Entity]
#[Table(name: "`material order`")]
class MaterialOrder extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "order_no", type: "smallint", nullable: true)]
    private ?int $orderNo;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $date;

    #[Column(type: "smallint", nullable: true)]
    private ?int $name;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $delivery;

    #[Column(type: "smallint", nullable: true)]
    private ?int $ref;

    #[Column(type: "decimal", nullable: true)]
    private ?string $quantity;

    #[Column(type: "smallint", nullable: true)]
    private ?int $unit;

    #[Column(type: "decimal", nullable: true)]
    private ?string $price;

    #[Column(type: "decimal", nullable: true)]
    private ?string $taxes;

    #[Column(name: "delivery_terms", type: "integer", nullable: true)]
    private ?int $deliveryTerms;

    #[Column(name: "delivery_address", type: "string", nullable: true)]
    private ?string $deliveryAddress;

    #[Column(name: "payments_terms", type: "string", nullable: true)]
    private ?string $paymentsTerms;

    #[Column(type: "string", nullable: true)]
    private ?string $reference;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(name: "receving_remarks", type: "string", nullable: true)]
    private ?string $recevingRemarks;

    #[Column(type: "integer", nullable: true)]
    private ?int $authorised;

    #[Column(type: "string", nullable: true)]
    private ?string $print;

    #[Column(type: "integer")]
    private int $updated;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(name: "a_operator", type: "smallint", nullable: true)]
    private ?int $aOperator;

    #[Column(name: "a_datetime", type: "datetime", nullable: true)]
    private ?DateTime $aDatetime;

    public function __construct()
    {
        $this->authorised = 0;
        $this->print = "Print";
        $this->updated = 0;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getOrderNo(): ?int
    {
        return $this->orderNo;
    }

    public function setOrderNo(?int $value): static
    {
        $this->orderNo = $value;
        return $this;
    }

    public function getDate(): ?DateTime
    {
        return $this->date;
    }

    public function setDate(?DateTime $value): static
    {
        $this->date = $value;
        return $this;
    }

    public function getName(): ?int
    {
        return $this->name;
    }

    public function setName(?int $value): static
    {
        $this->name = $value;
        return $this;
    }

    public function getDelivery(): ?DateTime
    {
        return $this->delivery;
    }

    public function setDelivery(?DateTime $value): static
    {
        $this->delivery = $value;
        return $this;
    }

    public function getRef(): ?int
    {
        return $this->ref;
    }

    public function setRef(?int $value): static
    {
        $this->ref = $value;
        return $this;
    }

    public function getQuantity(): ?string
    {
        return $this->quantity;
    }

    public function setQuantity(?string $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getUnit(): ?int
    {
        return $this->unit;
    }

    public function setUnit(?int $value): static
    {
        $this->unit = $value;
        return $this;
    }

    public function getPrice(): ?string
    {
        return $this->price;
    }

    public function setPrice(?string $value): static
    {
        $this->price = $value;
        return $this;
    }

    public function getTaxes(): ?string
    {
        return $this->taxes;
    }

    public function setTaxes(?string $value): static
    {
        $this->taxes = $value;
        return $this;
    }

    public function getDeliveryTerms(): ?int
    {
        return $this->deliveryTerms;
    }

    public function setDeliveryTerms(?int $value): static
    {
        $this->deliveryTerms = $value;
        return $this;
    }

    public function getDeliveryAddress(): ?string
    {
        return HtmlDecode($this->deliveryAddress);
    }

    public function setDeliveryAddress(?string $value): static
    {
        $this->deliveryAddress = RemoveXss($value);
        return $this;
    }

    public function getPaymentsTerms(): ?string
    {
        return HtmlDecode($this->paymentsTerms);
    }

    public function setPaymentsTerms(?string $value): static
    {
        $this->paymentsTerms = RemoveXss($value);
        return $this;
    }

    public function getReference(): ?string
    {
        return HtmlDecode($this->reference);
    }

    public function setReference(?string $value): static
    {
        $this->reference = RemoveXss($value);
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getRecevingRemarks(): ?string
    {
        return HtmlDecode($this->recevingRemarks);
    }

    public function setRecevingRemarks(?string $value): static
    {
        $this->recevingRemarks = RemoveXss($value);
        return $this;
    }

    public function getAuthorised(): ?int
    {
        return $this->authorised;
    }

    public function setAuthorised(?int $value): static
    {
        $this->authorised = $value;
        return $this;
    }

    public function getPrint(): ?string
    {
        return HtmlDecode($this->print);
    }

    public function setPrint(?string $value): static
    {
        $this->print = RemoveXss($value);
        return $this;
    }

    public function getUpdated(): int
    {
        return $this->updated;
    }

    public function setUpdated(int $value): static
    {
        $this->updated = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getAOperator(): ?int
    {
        return $this->aOperator;
    }

    public function setAOperator(?int $value): static
    {
        $this->aOperator = $value;
        return $this;
    }

    public function getADatetime(): ?DateTime
    {
        return $this->aDatetime;
    }

    public function setADatetime(?DateTime $value): static
    {
        $this->aDatetime = $value;
        return $this;
    }
}
