<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "margin_list_monthly" table
 */
#[Entity]
#[Table(name: "margin_list_monthly")]
class MarginListMonthly extends AbstractEntity
{
    #[Column(type: "smallint", nullable: true)]
    private ?int $grp;

    #[Column(name: "s_grp", type: "smallint", nullable: true)]
    private ?int $sGrp;

    #[Column(type: "smallint", nullable: true)]
    private ?int $product;

    #[Column(type: "smallint", nullable: true)]
    private ?int $rid;

    #[Column(name: "lot_no", type: "string", nullable: true)]
    private ?string $lotNo;

    #[Column(name: "margin_monthly", type: "float", nullable: true)]
    private ?float $marginMonthly;

    #[Column(name: "`margin_%`", options: ["name" => "margin_%"], type: "float", nullable: true)]
    private ?float $margin;

    #[Column(name: "packets_p", type: "decimal", nullable: true)]
    private ?string $packetsP;

    #[Column(name: "quantity_p", type: "decimal", nullable: true)]
    private ?string $quantityP;

    #[Column(name: "`@_p`", options: ["name" => "@_p"], type: "decimal", nullable: true)]
    private ?string $p;

    #[Column(name: "amount_p", type: "decimal", nullable: true)]
    private ?string $amountP;

    #[Column(name: "packets_s", type: "decimal", nullable: true)]
    private ?string $packetsS;

    #[Column(name: "quantity_s", type: "decimal", nullable: true)]
    private ?string $quantityS;

    #[Column(name: "`@_s`", options: ["name" => "@_s"], type: "float", nullable: true)]
    private ?float $s;

    #[Column(name: "amount_s", type: "float", nullable: true)]
    private ?float $amountS;

    #[Column(type: "integer", nullable: true)]
    private ?int $godown;

    #[Column(type: "string", nullable: true)]
    private ?string $ref;

    public function getGrp(): ?int
    {
        return $this->grp;
    }

    public function setGrp(?int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): ?int
    {
        return $this->sGrp;
    }

    public function setSGrp(?int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getProduct(): ?int
    {
        return $this->product;
    }

    public function setProduct(?int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getRid(): ?int
    {
        return $this->rid;
    }

    public function setRid(?int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getLotNo(): ?string
    {
        return HtmlDecode($this->lotNo);
    }

    public function setLotNo(?string $value): static
    {
        $this->lotNo = RemoveXss($value);
        return $this;
    }

    public function getMarginMonthly(): ?float
    {
        return $this->marginMonthly;
    }

    public function setMarginMonthly(?float $value): static
    {
        $this->marginMonthly = $value;
        return $this;
    }

    public function getMargin(): ?float
    {
        return $this->margin;
    }

    public function setMargin(?float $value): static
    {
        $this->margin = $value;
        return $this;
    }

    public function getPacketsP(): ?string
    {
        return $this->packetsP;
    }

    public function setPacketsP(?string $value): static
    {
        $this->packetsP = $value;
        return $this;
    }

    public function getQuantityP(): ?string
    {
        return $this->quantityP;
    }

    public function setQuantityP(?string $value): static
    {
        $this->quantityP = $value;
        return $this;
    }

    public function getP(): ?string
    {
        return $this->p;
    }

    public function setP(?string $value): static
    {
        $this->p = $value;
        return $this;
    }

    public function getAmountP(): ?string
    {
        return $this->amountP;
    }

    public function setAmountP(?string $value): static
    {
        $this->amountP = $value;
        return $this;
    }

    public function getPacketsS(): ?string
    {
        return $this->packetsS;
    }

    public function setPacketsS(?string $value): static
    {
        $this->packetsS = $value;
        return $this;
    }

    public function getQuantityS(): ?string
    {
        return $this->quantityS;
    }

    public function setQuantityS(?string $value): static
    {
        $this->quantityS = $value;
        return $this;
    }

    public function getS(): ?float
    {
        return $this->s;
    }

    public function setS(?float $value): static
    {
        $this->s = $value;
        return $this;
    }

    public function getAmountS(): ?float
    {
        return $this->amountS;
    }

    public function setAmountS(?float $value): static
    {
        $this->amountS = $value;
        return $this;
    }

    public function getGodown(): ?int
    {
        return $this->godown;
    }

    public function setGodown(?int $value): static
    {
        $this->godown = $value;
        return $this;
    }

    public function getRef(): ?string
    {
        return HtmlDecode($this->ref);
    }

    public function setRef(?string $value): static
    {
        $this->ref = RemoveXss($value);
        return $this;
    }
}
