<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "mail_setup" table
 */
#[Entity]
#[Table(name: "mail_setup")]
class MailSetup extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "user_name", type: "string")]
    private string $userName;

    #[Column(type: "string")]
    private string $password;

    #[Column(name: "smtp_server", type: "string")]
    private string $smtpServer;

    #[Column(type: "string")]
    private string $port;

    #[Column(name: "`ssl`", options: ["name" => "ssl"], type: "string")]
    private string $ssl;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(name: "company_id", type: "integer")]
    private int $companyId;

    #[Column(type: "integer")]
    private int $status;

    public function __construct()
    {
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getUserName(): string
    {
        return HtmlDecode($this->userName);
    }

    public function setUserName(string $value): static
    {
        $this->userName = RemoveXss($value);
        return $this;
    }

    public function getPassword(): string
    {
        return HtmlDecode($this->password);
    }

    public function setPassword(string $value): static
    {
        $this->password = RemoveXss($value);
        return $this;
    }

    public function getSmtpServer(): string
    {
        return HtmlDecode($this->smtpServer);
    }

    public function setSmtpServer(string $value): static
    {
        $this->smtpServer = RemoveXss($value);
        return $this;
    }

    public function getPort(): string
    {
        return HtmlDecode($this->port);
    }

    public function setPort(string $value): static
    {
        $this->port = RemoveXss($value);
        return $this;
    }

    public function getSsl(): string
    {
        return HtmlDecode($this->ssl);
    }

    public function setSsl(string $value): static
    {
        $this->ssl = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getCompanyId(): int
    {
        return $this->companyId;
    }

    public function setCompanyId(int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }
}
