<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "mail_record" table
 */
#[Entity]
#[Table(name: "mail_record")]
class MailRecord extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string")]
    private string $subject;

    #[Column(type: "text")]
    private string $message;

    #[Column(name: "mail_address", type: "string")]
    private string $mailAddress;

    #[Column(type: "string")]
    private string $status;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(name: "company_id", type: "integer")]
    private int $companyId;

    #[Column(name: "sender_id", type: "string")]
    private string $senderId;

    #[Column(name: "user_id", type: "smallint")]
    private int $userId;

    public function __construct()
    {
        $this->status = "0";
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getSubject(): string
    {
        return HtmlDecode($this->subject);
    }

    public function setSubject(string $value): static
    {
        $this->subject = RemoveXss($value);
        return $this;
    }

    public function getMessage(): string
    {
        return HtmlDecode($this->message);
    }

    public function setMessage(string $value): static
    {
        $this->message = RemoveXss($value);
        return $this;
    }

    public function getMailAddress(): string
    {
        return HtmlDecode($this->mailAddress);
    }

    public function setMailAddress(string $value): static
    {
        $this->mailAddress = RemoveXss($value);
        return $this;
    }

    public function getStatus(): string
    {
        return HtmlDecode($this->status);
    }

    public function setStatus(string $value): static
    {
        $this->status = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getCompanyId(): int
    {
        return $this->companyId;
    }

    public function setCompanyId(int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getSenderId(): string
    {
        return HtmlDecode($this->senderId);
    }

    public function setSenderId(string $value): static
    {
        $this->senderId = RemoveXss($value);
        return $this;
    }

    public function getUserId(): int
    {
        return $this->userId;
    }

    public function setUserId(int $value): static
    {
        $this->userId = $value;
        return $this;
    }
}
