<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "lot_no_details" table
 */
#[Entity]
#[Table(name: "lot_no_details")]
class LotNoDetail extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint", nullable: true)]
    private ?int $grp;

    #[Column(name: "s_grp", type: "smallint", nullable: true)]
    private ?int $sGrp;

    #[Column(type: "smallint", nullable: true)]
    private ?int $product;

    #[Column(type: "string", nullable: true)]
    private ?string $ref;

    #[Column(name: "packing_type", type: "smallint", nullable: true)]
    private ?int $packingType;

    #[Column(name: "lot_no", type: "string")]
    private string $lotNo;

    #[Column(name: "processed_at", type: "integer", nullable: true)]
    private ?int $processedAt;

    #[Column(type: "string", nullable: true)]
    private ?string $micron;

    #[Column(type: "string", nullable: true)]
    private ?string $length;

    #[Column(name: "balance_quantity", type: "decimal", nullable: true)]
    private ?string $balanceQuantity;

    #[Column(name: "balance_packets", type: "decimal", nullable: true)]
    private ?string $balancePackets;

    #[Column(name: "base_product", type: "decimal", nullable: true)]
    private ?string $baseProduct;

    #[Column(name: "byproduct_1", type: "decimal", nullable: true)]
    private ?string $byproduct1;

    #[Column(name: "byproduct_2", type: "decimal", nullable: true)]
    private ?string $byproduct2;

    #[Column(name: "byproduct_3", type: "decimal", nullable: true)]
    private ?string $byproduct3;

    #[Column(name: "byproduct_4", type: "decimal", nullable: true)]
    private ?string $byproduct4;

    #[Column(name: "in_quantity", type: "decimal")]
    private string $inQuantity;

    #[Column(name: "out_quantity", type: "decimal", nullable: true)]
    private ?string $outQuantity;

    #[Column(name: "in_packets", type: "decimal")]
    private string $inPackets;

    #[Column(name: "out_packets", type: "decimal", nullable: true)]
    private ?string $outPackets;

    #[Column(type: "smallint", nullable: true)]
    private ?int $age;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $dated;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(type: "integer", nullable: true)]
    private ?int $rid;

    #[Column(name: "employee_id", type: "smallint")]
    private int $employeeId;

    #[Column(name: "jc_no", type: "integer")]
    private int $jcNo;

    #[Column(name: "raw_qty", type: "decimal", nullable: true)]
    private ?string $rawQty;

    #[Column(name: "byproduct_1_in", type: "decimal")]
    private string $byproduct1In;

    #[Column(name: "byproduct_2_in", type: "decimal")]
    private string $byproduct2In;

    #[Column(name: "byproduct_3_in", type: "decimal")]
    private string $byproduct3In;

    #[Column(name: "byproduct_4_in", type: "decimal")]
    private string $byproduct4In;

    public function __construct()
    {
        $this->grp = ((isset($_GET["grp"])) ? $_GET["grp"] : ((isset($_COOKIE["grp"]))? $_COOKIE["grp"]:''));
        $this->sGrp = ((isset($_GET["s_grp"])) ? $_GET["s_grp"] : ((isset($_COOKIE["s_grp"]))? $_COOKIE["s_grp"]:''));
        $this->product = ((isset($_GET["product"])) ? $_GET["product"] : ((isset($_COOKIE["product"]))? $_COOKIE["product"]:''));
        $this->packingType = (isset($_COOKIE["pk"]))? $_COOKIE["pk"]:'';
        $this->lotNo = 'NA';
        $this->balanceQuantity = "0.000";
        $this->balancePackets = "0.00";
        $this->baseProduct = "0.00";
        $this->byproduct1 = "0.00";
        $this->byproduct2 = "0.00";
        $this->byproduct3 = "0.00";
        $this->byproduct4 = "0.00";
        $this->outQuantity = "0.000";
        $this->outPackets = "0.00";
        $this->operator = 0;
        $this->jcNo = 0;
        $this->rawQty = "0.000";
        $this->byproduct1In = "0.000";
        $this->byproduct2In = "0.000";
        $this->byproduct3In = "0.000";
        $this->byproduct4In = "0.000";
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getGrp(): ?int
    {
        return $this->grp;
    }

    public function setGrp(?int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): ?int
    {
        return $this->sGrp;
    }

    public function setSGrp(?int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getProduct(): ?int
    {
        return $this->product;
    }

    public function setProduct(?int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getRef(): ?string
    {
        return HtmlDecode($this->ref);
    }

    public function setRef(?string $value): static
    {
        $this->ref = RemoveXss($value);
        return $this;
    }

    public function getPackingType(): ?int
    {
        return $this->packingType;
    }

    public function setPackingType(?int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getLotNo(): string
    {
        return HtmlDecode($this->lotNo);
    }

    public function setLotNo(string $value): static
    {
        $this->lotNo = RemoveXss($value);
        return $this;
    }

    public function getProcessedAt(): ?int
    {
        return $this->processedAt;
    }

    public function setProcessedAt(?int $value): static
    {
        $this->processedAt = $value;
        return $this;
    }

    public function getMicron(): ?string
    {
        return HtmlDecode($this->micron);
    }

    public function setMicron(?string $value): static
    {
        $this->micron = RemoveXss($value);
        return $this;
    }

    public function getLength(): ?string
    {
        return HtmlDecode($this->length);
    }

    public function setLength(?string $value): static
    {
        $this->length = RemoveXss($value);
        return $this;
    }

    public function getBalanceQuantity(): ?string
    {
        return $this->balanceQuantity;
    }

    public function setBalanceQuantity(?string $value): static
    {
        $this->balanceQuantity = $value;
        return $this;
    }

    public function getBalancePackets(): ?string
    {
        return $this->balancePackets;
    }

    public function setBalancePackets(?string $value): static
    {
        $this->balancePackets = $value;
        return $this;
    }

    public function getBaseProduct(): ?string
    {
        return $this->baseProduct;
    }

    public function setBaseProduct(?string $value): static
    {
        $this->baseProduct = $value;
        return $this;
    }

    public function getByproduct1(): ?string
    {
        return $this->byproduct1;
    }

    public function setByproduct1(?string $value): static
    {
        $this->byproduct1 = $value;
        return $this;
    }

    public function getByproduct2(): ?string
    {
        return $this->byproduct2;
    }

    public function setByproduct2(?string $value): static
    {
        $this->byproduct2 = $value;
        return $this;
    }

    public function getByproduct3(): ?string
    {
        return $this->byproduct3;
    }

    public function setByproduct3(?string $value): static
    {
        $this->byproduct3 = $value;
        return $this;
    }

    public function getByproduct4(): ?string
    {
        return $this->byproduct4;
    }

    public function setByproduct4(?string $value): static
    {
        $this->byproduct4 = $value;
        return $this;
    }

    public function getInQuantity(): string
    {
        return $this->inQuantity;
    }

    public function setInQuantity(string $value): static
    {
        $this->inQuantity = $value;
        return $this;
    }

    public function getOutQuantity(): ?string
    {
        return $this->outQuantity;
    }

    public function setOutQuantity(?string $value): static
    {
        $this->outQuantity = $value;
        return $this;
    }

    public function getInPackets(): string
    {
        return $this->inPackets;
    }

    public function setInPackets(string $value): static
    {
        $this->inPackets = $value;
        return $this;
    }

    public function getOutPackets(): ?string
    {
        return $this->outPackets;
    }

    public function setOutPackets(?string $value): static
    {
        $this->outPackets = $value;
        return $this;
    }

    public function getAge(): ?int
    {
        return $this->age;
    }

    public function setAge(?int $value): static
    {
        $this->age = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getDated(): ?DateTime
    {
        return $this->dated;
    }

    public function setDated(?DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getRid(): ?int
    {
        return $this->rid;
    }

    public function setRid(?int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getEmployeeId(): int
    {
        return $this->employeeId;
    }

    public function setEmployeeId(int $value): static
    {
        $this->employeeId = $value;
        return $this;
    }

    public function getJcNo(): int
    {
        return $this->jcNo;
    }

    public function setJcNo(int $value): static
    {
        $this->jcNo = $value;
        return $this;
    }

    public function getRawQty(): ?string
    {
        return $this->rawQty;
    }

    public function setRawQty(?string $value): static
    {
        $this->rawQty = $value;
        return $this;
    }

    public function getByproduct1In(): string
    {
        return $this->byproduct1In;
    }

    public function setByproduct1In(string $value): static
    {
        $this->byproduct1In = $value;
        return $this;
    }

    public function getByproduct2In(): string
    {
        return $this->byproduct2In;
    }

    public function setByproduct2In(string $value): static
    {
        $this->byproduct2In = $value;
        return $this;
    }

    public function getByproduct3In(): string
    {
        return $this->byproduct3In;
    }

    public function setByproduct3In(string $value): static
    {
        $this->byproduct3In = $value;
        return $this;
    }

    public function getByproduct4In(): string
    {
        return $this->byproduct4In;
    }

    public function setByproduct4In(string $value): static
    {
        $this->byproduct4In = $value;
        return $this;
    }
}
