<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "loom_info" table
 */
#[Entity]
#[Table(name: "loom_info")]
class LoomInfo extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $grp;

    #[Column(type: "smallint")]
    private int $works;

    #[Column(type: "string", unique: true, nullable: true)]
    private ?string $item;

    #[Column(name: "size_width", type: "string")]
    private string $sizeWidth;

    #[Column(name: "prod_sqm_daily", type: "smallint", nullable: true)]
    private ?int $prodSqmDaily;

    #[Column(type: "integer")]
    private int $status;

    #[Column(name: "a_barcode", type: "smallint")]
    private int $aBarcode;

    #[Column(name: "p_sqm", type: "decimal")]
    private string $pSqm;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(type: "string")]
    private string $uid;

    #[Column(type: "smallint")]
    private int $process;

    #[Column(type: "smallint", nullable: true)]
    private ?int $category;

    #[Column(name: "s_prod", type: "decimal", nullable: true)]
    private ?string $sProd;

    public function __construct()
    {
        $this->grp = 3;
        $this->sizeWidth = "0";
        $this->prodSqmDaily = 0;
        $this->pSqm = "0.000";
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getGrp(): int
    {
        return $this->grp;
    }

    public function setGrp(int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getWorks(): int
    {
        return $this->works;
    }

    public function setWorks(int $value): static
    {
        $this->works = $value;
        return $this;
    }

    public function getItem(): ?string
    {
        return HtmlDecode($this->item);
    }

    public function setItem(?string $value): static
    {
        $this->item = RemoveXss($value);
        return $this;
    }

    public function getSizeWidth(): string
    {
        return HtmlDecode($this->sizeWidth);
    }

    public function setSizeWidth(string $value): static
    {
        $this->sizeWidth = RemoveXss($value);
        return $this;
    }

    public function getProdSqmDaily(): ?int
    {
        return $this->prodSqmDaily;
    }

    public function setProdSqmDaily(?int $value): static
    {
        $this->prodSqmDaily = $value;
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getABarcode(): int
    {
        return $this->aBarcode;
    }

    public function setABarcode(int $value): static
    {
        $this->aBarcode = $value;
        return $this;
    }

    public function getPSqm(): string
    {
        return $this->pSqm;
    }

    public function setPSqm(string $value): static
    {
        $this->pSqm = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getUid(): string
    {
        return HtmlDecode($this->uid);
    }

    public function setUid(string $value): static
    {
        $this->uid = RemoveXss($value);
        return $this;
    }

    public function getProcess(): int
    {
        return $this->process;
    }

    public function setProcess(int $value): static
    {
        $this->process = $value;
        return $this;
    }

    public function getCategory(): ?int
    {
        return $this->category;
    }

    public function setCategory(?int $value): static
    {
        $this->category = $value;
        return $this;
    }

    public function getSProd(): ?string
    {
        return $this->sProd;
    }

    public function setSProd(?string $value): static
    {
        $this->sProd = $value;
        return $this;
    }
}
