<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "loginip" table
 */
#[Entity]
#[Table(name: "loginip")]
class Loginip extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $user;

    #[Column(type: "string", nullable: true)]
    private ?string $ip;

    #[Column(name: "time_limit", type: "datetime")]
    private DateTime $timeLimit;

    #[Column(name: "start_time", type: "time")]
    private DateTime $startTime;

    #[Column(name: "end_time", type: "time")]
    private DateTime $endTime;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getUser(): int
    {
        return $this->user;
    }

    public function setUser(int $value): static
    {
        $this->user = $value;
        return $this;
    }

    public function getIp(): ?string
    {
        return HtmlDecode($this->ip);
    }

    public function setIp(?string $value): static
    {
        $this->ip = RemoveXss($value);
        return $this;
    }

    public function getTimeLimit(): DateTime
    {
        return $this->timeLimit;
    }

    public function setTimeLimit(DateTime $value): static
    {
        $this->timeLimit = $value;
        return $this;
    }

    public function getStartTime(): DateTime
    {
        return $this->startTime;
    }

    public function setStartTime(DateTime $value): static
    {
        $this->startTime = $value;
        return $this;
    }

    public function getEndTime(): DateTime
    {
        return $this->endTime;
    }

    public function setEndTime(DateTime $value): static
    {
        $this->endTime = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
