<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "locations" table
 */
#[Entity]
#[Table(name: "locations")]
class Location extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "float")]
    private float $latitude;

    #[Column(type: "float")]
    private float $longitude;

    #[Column(type: "geometry")]
    private string $coordinate;

    #[Column(type: "integer")]
    private int $tid;

    #[Column(type: "string", nullable: true)]
    private ?string $code;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(name: "e_operator", type: "smallint", nullable: true)]
    private ?int $eOperator;

    #[Column(name: "e_datetime", type: "datetime", nullable: true)]
    private ?DateTime $eDatetime;

    public function __construct()
    {
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getLatitude(): float
    {
        return $this->latitude;
    }

    public function setLatitude(float $value): static
    {
        $this->latitude = $value;
        return $this;
    }

    public function getLongitude(): float
    {
        return $this->longitude;
    }

    public function setLongitude(float $value): static
    {
        $this->longitude = $value;
        return $this;
    }

    public function getCoordinate(): string
    {
        return $this->coordinate;
    }

    public function setCoordinate(string $value): static
    {
        $this->coordinate = $value;
        return $this;
    }

    public function getTid(): int
    {
        return $this->tid;
    }

    public function setTid(int $value): static
    {
        $this->tid = $value;
        return $this;
    }

    public function getCode(): ?string
    {
        return HtmlDecode($this->code);
    }

    public function setCode(?string $value): static
    {
        $this->code = RemoveXss($value);
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getEOperator(): ?int
    {
        return $this->eOperator;
    }

    public function setEOperator(?int $value): static
    {
        $this->eOperator = $value;
        return $this;
    }

    public function getEDatetime(): ?DateTime
    {
        return $this->eDatetime;
    }

    public function setEDatetime(?DateTime $value): static
    {
        $this->eDatetime = $value;
        return $this;
    }
}
