<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "ledger" table
 */
#[Entity]
#[Table(name: "ledger")]
class Ledger extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $uid;

    #[Column(type: "datetime")]
    private DateTime $dated;

    #[Column(name: "ref_account", type: "integer", nullable: true)]
    private ?int $refAccount;

    #[Column(name: "Balance", type: "decimal", nullable: true)]
    private ?string $balance;

    #[Column(name: "cumulative_sum", type: "decimal", nullable: true)]
    private ?string $cumulativeSum;

    #[Column(type: "string")]
    private string $type;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(name: "r_from", type: "integer", nullable: true)]
    private ?int $rFrom;

    #[Column(type: "string", nullable: true)]
    private ?string $name;

    #[Column(type: "string", nullable: true)]
    private ?string $ref;

    #[Column(type: "string", nullable: true)]
    private ?string $uploads;

    #[Column(type: "string", nullable: true)]
    private ?string $id;

    public function __construct()
    {
        $this->type = "0";
        $this->id = "0";
    }

    public function getUid(): int
    {
        return $this->uid;
    }

    public function setUid(int $value): static
    {
        $this->uid = $value;
        return $this;
    }

    public function getDated(): DateTime
    {
        return $this->dated;
    }

    public function setDated(DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }

    public function getRefAccount(): ?int
    {
        return $this->refAccount;
    }

    public function setRefAccount(?int $value): static
    {
        $this->refAccount = $value;
        return $this;
    }

    public function getBalance(): ?string
    {
        return $this->balance;
    }

    public function setBalance(?string $value): static
    {
        $this->balance = $value;
        return $this;
    }

    public function getCumulativeSum(): ?string
    {
        return $this->cumulativeSum;
    }

    public function setCumulativeSum(?string $value): static
    {
        $this->cumulativeSum = $value;
        return $this;
    }

    public function getType(): string
    {
        return HtmlDecode($this->type);
    }

    public function setType(string $value): static
    {
        $this->type = RemoveXss($value);
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getRFrom(): ?int
    {
        return $this->rFrom;
    }

    public function setRFrom(?int $value): static
    {
        $this->rFrom = $value;
        return $this;
    }

    public function getName(): ?string
    {
        return HtmlDecode($this->name);
    }

    public function setName(?string $value): static
    {
        $this->name = RemoveXss($value);
        return $this;
    }

    public function getRef(): ?string
    {
        return HtmlDecode($this->ref);
    }

    public function setRef(?string $value): static
    {
        $this->ref = RemoveXss($value);
        return $this;
    }

    public function getUploads(): ?string
    {
        return HtmlDecode($this->uploads);
    }

    public function setUploads(?string $value): static
    {
        $this->uploads = RemoveXss($value);
        return $this;
    }

    public function getId(): ?string
    {
        return HtmlDecode($this->id);
    }

    public function setId(?string $value): static
    {
        $this->id = RemoveXss($value);
        return $this;
    }
}
