<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "l_receipt" table
 */
#[Entity]
#[Table(name: "l_receipt")]
class LReceipt extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "r_from", type: "integer")]
    private int $rFrom;

    #[Column(name: "r_to", type: "integer")]
    private int $rTo;

    #[Column(name: "d_id", type: "string")]
    private string $dId;

    #[Column(name: "total_amount", type: "decimal")]
    private string $totalAmount;

    #[Column(name: "discount_amount", type: "decimal")]
    private string $discountAmount;

    #[Column(name: "receipt_amount", type: "decimal")]
    private string $receiptAmount;

    #[Column(type: "date")]
    private DateTime $dated;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "string", nullable: true)]
    private ?string $uploads;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(type: "integer")]
    private int $updated;

    public function __construct()
    {
        $this->discountAmount = "0.00";
        $this->receiptAmount = "0.00";
        $this->operator = 0;
        $this->updated = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getRFrom(): int
    {
        return $this->rFrom;
    }

    public function setRFrom(int $value): static
    {
        $this->rFrom = $value;
        return $this;
    }

    public function getRTo(): int
    {
        return $this->rTo;
    }

    public function setRTo(int $value): static
    {
        $this->rTo = $value;
        return $this;
    }

    public function getDId(): string
    {
        return HtmlDecode($this->dId);
    }

    public function setDId(string $value): static
    {
        $this->dId = RemoveXss($value);
        return $this;
    }

    public function getTotalAmount(): string
    {
        return $this->totalAmount;
    }

    public function setTotalAmount(string $value): static
    {
        $this->totalAmount = $value;
        return $this;
    }

    public function getDiscountAmount(): string
    {
        return $this->discountAmount;
    }

    public function setDiscountAmount(string $value): static
    {
        $this->discountAmount = $value;
        return $this;
    }

    public function getReceiptAmount(): string
    {
        return $this->receiptAmount;
    }

    public function setReceiptAmount(string $value): static
    {
        $this->receiptAmount = $value;
        return $this;
    }

    public function getDated(): DateTime
    {
        return $this->dated;
    }

    public function setDated(DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getUploads(): ?string
    {
        return HtmlDecode($this->uploads);
    }

    public function setUploads(?string $value): static
    {
        $this->uploads = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getUpdated(): int
    {
        return $this->updated;
    }

    public function setUpdated(int $value): static
    {
        $this->updated = $value;
        return $this;
    }
}
