<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "l_examination_type" table
 */
#[Entity]
#[Table(name: "l_examination_type")]
class LExaminationType extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $grp;

    #[Column(name: "report_grp", type: "smallint")]
    private int $reportGrp;

    #[Column(type: "string")]
    private string $name;

    #[Column(type: "decimal")]
    private string $price;

    #[Column(name: "max_discount", type: "decimal")]
    private string $maxDiscount;

    #[Column(type: "string")]
    private string $code;

    #[Column(name: "standard_min", type: "string")]
    private string $standardMin;

    #[Column(name: "standard_max", type: "string")]
    private string $standardMax;

    #[Column(name: "standard_unit", type: "string")]
    private string $standardUnit;

    #[Column(type: "text", nullable: true)]
    private ?string $header;

    #[Column(type: "text", nullable: true)]
    private ?string $footer;

    #[Column(name: "process_time_hours", type: "smallint")]
    private int $processTimeHours;

    #[Column(type: "integer")]
    private int $status;

    #[Column(name: "diagnosis_code", type: "text", nullable: true)]
    private ?string $diagnosisCode;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->reportGrp = 0;
        $this->standardMax = "0.00";
        $this->status = 1;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getGrp(): int
    {
        return $this->grp;
    }

    public function setGrp(int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getReportGrp(): int
    {
        return $this->reportGrp;
    }

    public function setReportGrp(int $value): static
    {
        $this->reportGrp = $value;
        return $this;
    }

    public function getName(): string
    {
        return HtmlDecode($this->name);
    }

    public function setName(string $value): static
    {
        $this->name = RemoveXss($value);
        return $this;
    }

    public function getPrice(): string
    {
        return $this->price;
    }

    public function setPrice(string $value): static
    {
        $this->price = $value;
        return $this;
    }

    public function getMaxDiscount(): string
    {
        return $this->maxDiscount;
    }

    public function setMaxDiscount(string $value): static
    {
        $this->maxDiscount = $value;
        return $this;
    }

    public function getCode(): string
    {
        return HtmlDecode($this->code);
    }

    public function setCode(string $value): static
    {
        $this->code = RemoveXss($value);
        return $this;
    }

    public function getStandardMin(): string
    {
        return HtmlDecode($this->standardMin);
    }

    public function setStandardMin(string $value): static
    {
        $this->standardMin = RemoveXss($value);
        return $this;
    }

    public function getStandardMax(): string
    {
        return HtmlDecode($this->standardMax);
    }

    public function setStandardMax(string $value): static
    {
        $this->standardMax = RemoveXss($value);
        return $this;
    }

    public function getStandardUnit(): string
    {
        return HtmlDecode($this->standardUnit);
    }

    public function setStandardUnit(string $value): static
    {
        $this->standardUnit = RemoveXss($value);
        return $this;
    }

    public function getHeader(): ?string
    {
        return HtmlDecode($this->header);
    }

    public function setHeader(?string $value): static
    {
        $this->header = RemoveXss($value);
        return $this;
    }

    public function getFooter(): ?string
    {
        return HtmlDecode($this->footer);
    }

    public function setFooter(?string $value): static
    {
        $this->footer = RemoveXss($value);
        return $this;
    }

    public function getProcessTimeHours(): int
    {
        return $this->processTimeHours;
    }

    public function setProcessTimeHours(int $value): static
    {
        $this->processTimeHours = $value;
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getDiagnosisCode(): ?string
    {
        return HtmlDecode($this->diagnosisCode);
    }

    public function setDiagnosisCode(?string $value): static
    {
        $this->diagnosisCode = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
