<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "l_examination_report" table
 */
#[Entity]
#[Table(name: "l_examination_report")]
class LExaminationReport extends AbstractEntity
{
    #[Column(name: "d_id", type: "integer")]
    private int $dId;

    #[Column(type: "string", nullable: true)]
    private ?string $mobile;

    #[Column(type: "string", nullable: true)]
    private ?string $name;

    #[Column(name: "examination_code", type: "string")]
    private string $examinationCode;

    #[Column(name: "diagnosis_value", type: "string", nullable: true)]
    private ?string $diagnosisValue;

    #[Column(name: "diagnosis_st_min", type: "decimal", nullable: true)]
    private ?string $diagnosisStMin;

    #[Column(name: "diagnosis_st_max", type: "decimal", nullable: true)]
    private ?string $diagnosisStMax;

    #[Column(name: "diagnosis_unit", type: "string", nullable: true)]
    private ?string $diagnosisUnit;

    #[Column(name: "balance_amount", type: "decimal")]
    private string $balanceAmount;

    #[Column(type: "integer")]
    private int $age;

    #[Column(type: "integer")]
    private int $sex;

    #[Column(type: "smallint", nullable: true)]
    private ?int $referral;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(name: "examination_grp", type: "smallint")]
    private int $examinationGrp;

    #[Column(name: "diagnosis_datetime", type: "datetime", nullable: true)]
    private ?DateTime $diagnosisDatetime;

    #[Column(name: "import_value", type: "string")]
    private string $importValue;

    #[Column(name: "total_amount", type: "decimal")]
    private string $totalAmount;

    #[Column(name: "discount_amount", type: "decimal")]
    private string $discountAmount;

    #[Column(name: "received_amount", type: "decimal")]
    private string $receivedAmount;

    #[Column(name: "examination_id", type: "smallint", nullable: true)]
    private ?int $examinationId;

    #[Column(name: "examination_name", type: "string")]
    private string $examinationName;

    #[Id]
    #[Column(type: "string", unique: true)]
    private string $uid;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(type: "smallint")]
    private int $user;

    #[Column(name: "report_grp", type: "smallint", nullable: true)]
    private ?int $reportGrp;

    public function __construct()
    {
        $this->discountAmount = "0.00";
        $this->operator = 0;
        $this->reportGrp = 0;
    }

    public function getDId(): int
    {
        return $this->dId;
    }

    public function setDId(int $value): static
    {
        $this->dId = $value;
        return $this;
    }

    public function getMobile(): ?string
    {
        return HtmlDecode($this->mobile);
    }

    public function setMobile(?string $value): static
    {
        $this->mobile = RemoveXss($value);
        return $this;
    }

    public function getName(): ?string
    {
        return HtmlDecode($this->name);
    }

    public function setName(?string $value): static
    {
        $this->name = RemoveXss($value);
        return $this;
    }

    public function getExaminationCode(): string
    {
        return HtmlDecode($this->examinationCode);
    }

    public function setExaminationCode(string $value): static
    {
        $this->examinationCode = RemoveXss($value);
        return $this;
    }

    public function getDiagnosisValue(): ?string
    {
        return HtmlDecode($this->diagnosisValue);
    }

    public function setDiagnosisValue(?string $value): static
    {
        $this->diagnosisValue = RemoveXss($value);
        return $this;
    }

    public function getDiagnosisStMin(): ?string
    {
        return $this->diagnosisStMin;
    }

    public function setDiagnosisStMin(?string $value): static
    {
        $this->diagnosisStMin = $value;
        return $this;
    }

    public function getDiagnosisStMax(): ?string
    {
        return $this->diagnosisStMax;
    }

    public function setDiagnosisStMax(?string $value): static
    {
        $this->diagnosisStMax = $value;
        return $this;
    }

    public function getDiagnosisUnit(): ?string
    {
        return HtmlDecode($this->diagnosisUnit);
    }

    public function setDiagnosisUnit(?string $value): static
    {
        $this->diagnosisUnit = RemoveXss($value);
        return $this;
    }

    public function getBalanceAmount(): string
    {
        return $this->balanceAmount;
    }

    public function setBalanceAmount(string $value): static
    {
        $this->balanceAmount = $value;
        return $this;
    }

    public function getAge(): int
    {
        return $this->age;
    }

    public function setAge(int $value): static
    {
        $this->age = $value;
        return $this;
    }

    public function getSex(): int
    {
        return $this->sex;
    }

    public function setSex(int $value): static
    {
        $this->sex = $value;
        return $this;
    }

    public function getReferral(): ?int
    {
        return $this->referral;
    }

    public function setReferral(?int $value): static
    {
        $this->referral = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getExaminationGrp(): int
    {
        return $this->examinationGrp;
    }

    public function setExaminationGrp(int $value): static
    {
        $this->examinationGrp = $value;
        return $this;
    }

    public function getDiagnosisDatetime(): ?DateTime
    {
        return $this->diagnosisDatetime;
    }

    public function setDiagnosisDatetime(?DateTime $value): static
    {
        $this->diagnosisDatetime = $value;
        return $this;
    }

    public function getImportValue(): string
    {
        return HtmlDecode($this->importValue);
    }

    public function setImportValue(string $value): static
    {
        $this->importValue = RemoveXss($value);
        return $this;
    }

    public function getTotalAmount(): string
    {
        return $this->totalAmount;
    }

    public function setTotalAmount(string $value): static
    {
        $this->totalAmount = $value;
        return $this;
    }

    public function getDiscountAmount(): string
    {
        return $this->discountAmount;
    }

    public function setDiscountAmount(string $value): static
    {
        $this->discountAmount = $value;
        return $this;
    }

    public function getReceivedAmount(): string
    {
        return $this->receivedAmount;
    }

    public function setReceivedAmount(string $value): static
    {
        $this->receivedAmount = $value;
        return $this;
    }

    public function getExaminationId(): ?int
    {
        return $this->examinationId;
    }

    public function setExaminationId(?int $value): static
    {
        $this->examinationId = $value;
        return $this;
    }

    public function getExaminationName(): string
    {
        return HtmlDecode($this->examinationName);
    }

    public function setExaminationName(string $value): static
    {
        $this->examinationName = RemoveXss($value);
        return $this;
    }

    public function getUid(): string
    {
        return $this->uid;
    }

    public function setUid(string $value): static
    {
        $this->uid = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getUser(): int
    {
        return $this->user;
    }

    public function setUser(int $value): static
    {
        $this->user = $value;
        return $this;
    }

    public function getReportGrp(): ?int
    {
        return $this->reportGrp;
    }

    public function setReportGrp(?int $value): static
    {
        $this->reportGrp = $value;
        return $this;
    }
}
