<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "l_examination" table
 */
#[Entity]
#[Table(name: "l_examination")]
class LExamination extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string", nullable: true)]
    private ?string $mobile;

    #[Column(type: "smallint")]
    private int $user;

    #[Column(type: "integer")]
    private int $category;

    #[Column(type: "string", nullable: true)]
    private ?string $name;

    #[Column(type: "integer")]
    private int $age;

    #[Column(type: "integer")]
    private int $sex;

    #[Column(type: "smallint", nullable: true)]
    private ?int $referral;

    #[Column(name: "examination_grp", type: "string", nullable: true)]
    private ?string $examinationGrp;

    #[Column(name: "examination_type", type: "string")]
    private string $examinationType;

    #[Column(name: "total_amount", type: "decimal")]
    private string $totalAmount;

    #[Column(name: "discount_percent", type: "decimal")]
    private string $discountPercent;

    #[Column(name: "discount_amount", type: "decimal")]
    private string $discountAmount;

    #[Column(name: "final_amount", type: "decimal")]
    private string $finalAmount;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(type: "decimal")]
    private string $receipt;

    public function __construct()
    {
        $this->category = 0;
        $this->discountPercent = "0.00";
        $this->operator = 0;
        $this->receipt = "0.00";
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getMobile(): ?string
    {
        return HtmlDecode($this->mobile);
    }

    public function setMobile(?string $value): static
    {
        $this->mobile = RemoveXss($value);
        return $this;
    }

    public function getUser(): int
    {
        return $this->user;
    }

    public function setUser(int $value): static
    {
        $this->user = $value;
        return $this;
    }

    public function getCategory(): int
    {
        return $this->category;
    }

    public function setCategory(int $value): static
    {
        $this->category = $value;
        return $this;
    }

    public function getName(): ?string
    {
        return HtmlDecode($this->name);
    }

    public function setName(?string $value): static
    {
        $this->name = RemoveXss($value);
        return $this;
    }

    public function getAge(): int
    {
        return $this->age;
    }

    public function setAge(int $value): static
    {
        $this->age = $value;
        return $this;
    }

    public function getSex(): int
    {
        return $this->sex;
    }

    public function setSex(int $value): static
    {
        $this->sex = $value;
        return $this;
    }

    public function getReferral(): ?int
    {
        return $this->referral;
    }

    public function setReferral(?int $value): static
    {
        $this->referral = $value;
        return $this;
    }

    public function getExaminationGrp(): ?string
    {
        return HtmlDecode($this->examinationGrp);
    }

    public function setExaminationGrp(?string $value): static
    {
        $this->examinationGrp = RemoveXss($value);
        return $this;
    }

    public function getExaminationType(): string
    {
        return HtmlDecode($this->examinationType);
    }

    public function setExaminationType(string $value): static
    {
        $this->examinationType = RemoveXss($value);
        return $this;
    }

    public function getTotalAmount(): string
    {
        return $this->totalAmount;
    }

    public function setTotalAmount(string $value): static
    {
        $this->totalAmount = $value;
        return $this;
    }

    public function getDiscountPercent(): string
    {
        return $this->discountPercent;
    }

    public function setDiscountPercent(string $value): static
    {
        $this->discountPercent = $value;
        return $this;
    }

    public function getDiscountAmount(): string
    {
        return $this->discountAmount;
    }

    public function setDiscountAmount(string $value): static
    {
        $this->discountAmount = $value;
        return $this;
    }

    public function getFinalAmount(): string
    {
        return $this->finalAmount;
    }

    public function setFinalAmount(string $value): static
    {
        $this->finalAmount = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getReceipt(): string
    {
        return $this->receipt;
    }

    public function setReceipt(string $value): static
    {
        $this->receipt = $value;
        return $this;
    }
}
