<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "job_card_pending_query" table
 */
#[Entity]
#[Table(name: "job_card_pending_query")]
class JobCardPendingQuery extends AbstractEntity
{
    #[Column(type: "integer", nullable: true)]
    private ?int $works;

    #[Column(type: "integer", nullable: true)]
    private ?int $po;

    #[Column(name: "jc_no", type: "integer")]
    private int $jcNo;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(name: "emp_name", type: "string", nullable: true)]
    private ?string $empName;

    #[Column(type: "bigint", nullable: true)]
    private ?string $tqty;

    #[Column(type: "bigint")]
    private string $count;

    #[Column(type: "float", nullable: true)]
    private ?float $tsqm;

    #[Column(type: "float")]
    private float $psqm;

    #[Column(name: "pending_days", type: "integer", nullable: true)]
    private ?int $pendingDays;

    #[Column(name: "design_size", type: "string", nullable: true)]
    private ?string $designSize;

    #[Column(type: "text", nullable: true)]
    private ?string $barcode;

    #[Column(name: "buyers_id", type: "integer", nullable: true)]
    private ?int $buyersId;

    #[Column(name: "plan_week", type: "smallint", nullable: true)]
    private ?int $planWeek;

    #[Column(name: "dispatch_date", type: "smallint", nullable: true)]
    private ?int $dispatchDate;

    #[Column(name: "loom_no", type: "smallint", nullable: true)]
    private ?int $loomNo;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "text", nullable: true)]
    private ?string $completed;

    #[Column(type: "text", nullable: true)]
    private ?string $status;

    #[Id]
    #[Column(type: "integer", nullable: true)]
    private ?int $id;

    public function __construct()
    {
        $this->jcNo = 0;
        $this->count = "0";
        $this->psqm = 0;
        $this->barcode = "0";
        $this->operator = 0;
    }

    public function getWorks(): ?int
    {
        return $this->works;
    }

    public function setWorks(?int $value): static
    {
        $this->works = $value;
        return $this;
    }

    public function getPo(): ?int
    {
        return $this->po;
    }

    public function setPo(?int $value): static
    {
        $this->po = $value;
        return $this;
    }

    public function getJcNo(): int
    {
        return $this->jcNo;
    }

    public function setJcNo(int $value): static
    {
        $this->jcNo = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getEmpName(): ?string
    {
        return HtmlDecode($this->empName);
    }

    public function setEmpName(?string $value): static
    {
        $this->empName = RemoveXss($value);
        return $this;
    }

    public function getTqty(): ?string
    {
        return $this->tqty;
    }

    public function setTqty(?string $value): static
    {
        $this->tqty = $value;
        return $this;
    }

    public function getCount(): string
    {
        return $this->count;
    }

    public function setCount(string $value): static
    {
        $this->count = $value;
        return $this;
    }

    public function getTsqm(): ?float
    {
        return $this->tsqm;
    }

    public function setTsqm(?float $value): static
    {
        $this->tsqm = $value;
        return $this;
    }

    public function getPsqm(): float
    {
        return $this->psqm;
    }

    public function setPsqm(float $value): static
    {
        $this->psqm = $value;
        return $this;
    }

    public function getPendingDays(): ?int
    {
        return $this->pendingDays;
    }

    public function setPendingDays(?int $value): static
    {
        $this->pendingDays = $value;
        return $this;
    }

    public function getDesignSize(): ?string
    {
        return HtmlDecode($this->designSize);
    }

    public function setDesignSize(?string $value): static
    {
        $this->designSize = RemoveXss($value);
        return $this;
    }

    public function getBarcode(): ?string
    {
        return HtmlDecode($this->barcode);
    }

    public function setBarcode(?string $value): static
    {
        $this->barcode = RemoveXss($value);
        return $this;
    }

    public function getBuyersId(): ?int
    {
        return $this->buyersId;
    }

    public function setBuyersId(?int $value): static
    {
        $this->buyersId = $value;
        return $this;
    }

    public function getPlanWeek(): ?int
    {
        return $this->planWeek;
    }

    public function setPlanWeek(?int $value): static
    {
        $this->planWeek = $value;
        return $this;
    }

    public function getDispatchDate(): ?int
    {
        return $this->dispatchDate;
    }

    public function setDispatchDate(?int $value): static
    {
        $this->dispatchDate = $value;
        return $this;
    }

    public function getLoomNo(): ?int
    {
        return $this->loomNo;
    }

    public function setLoomNo(?int $value): static
    {
        $this->loomNo = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getCompleted(): ?string
    {
        return HtmlDecode($this->completed);
    }

    public function setCompleted(?string $value): static
    {
        $this->completed = RemoveXss($value);
        return $this;
    }

    public function getStatus(): ?string
    {
        return HtmlDecode($this->status);
    }

    public function setStatus(?string $value): static
    {
        $this->status = RemoveXss($value);
        return $this;
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(?int $value): static
    {
        $this->id = $value;
        return $this;
    }
}
