<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "job_card_hs" table
 */
#[Entity]
#[Table(name: "job_card_hs")]
class JobCardH extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "integer", nullable: true)]
    private ?int $works;

    #[Column(name: "jc_no_fp", type: "integer")]
    private int $jcNoFp;

    #[Column(type: "string")]
    private string $item;

    #[Column(name: "batch_no", type: "smallint", nullable: true)]
    private ?int $batchNo;

    #[Column(type: "string")]
    private string $po;

    #[Column(name: "employee_id", type: "string")]
    private string $employeeId;

    #[Column(name: "avl_qty", type: "float")]
    private float $avlQty;

    #[Column(type: "float")]
    private float $quantity;

    #[Column(type: "string", nullable: true)]
    private ?string $1;

    #[Column(type: "string", nullable: true)]
    private ?string $2;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(type: "smallint", nullable: true)]
    private ?int $grp;

    #[Column(name: "s_grp", type: "integer")]
    private int $sGrp;

    #[Column(name: "jc_no_hs", type: "integer", unique: true, nullable: true)]
    private ?int $jcNoHs;

    #[Column(type: "integer", nullable: true)]
    private ?int $updated;

    public function __construct()
    {
        $this->works = (isset($_COOKIE["User_Site"]))? $_COOKIE["User_Site"]:"";
        $this->operator = 0;
        $this->grp = 23;
        $this->sGrp = 23;
        $this->updated = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getWorks(): ?int
    {
        return $this->works;
    }

    public function setWorks(?int $value): static
    {
        $this->works = $value;
        return $this;
    }

    public function getJcNoFp(): int
    {
        return $this->jcNoFp;
    }

    public function setJcNoFp(int $value): static
    {
        $this->jcNoFp = $value;
        return $this;
    }

    public function getItem(): string
    {
        return HtmlDecode($this->item);
    }

    public function setItem(string $value): static
    {
        $this->item = RemoveXss($value);
        return $this;
    }

    public function getBatchNo(): ?int
    {
        return $this->batchNo;
    }

    public function setBatchNo(?int $value): static
    {
        $this->batchNo = $value;
        return $this;
    }

    public function getPo(): string
    {
        return HtmlDecode($this->po);
    }

    public function setPo(string $value): static
    {
        $this->po = RemoveXss($value);
        return $this;
    }

    public function getEmployeeId(): string
    {
        return HtmlDecode($this->employeeId);
    }

    public function setEmployeeId(string $value): static
    {
        $this->employeeId = RemoveXss($value);
        return $this;
    }

    public function getAvlQty(): float
    {
        return $this->avlQty;
    }

    public function setAvlQty(float $value): static
    {
        $this->avlQty = $value;
        return $this;
    }

    public function getQuantity(): float
    {
        return $this->quantity;
    }

    public function setQuantity(float $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function get1(): ?string
    {
        return HtmlDecode($this->1);
    }

    public function set1(?string $value): static
    {
        $this->1 = RemoveXss($value);
        return $this;
    }

    public function get2(): ?string
    {
        return HtmlDecode($this->2);
    }

    public function set2(?string $value): static
    {
        $this->2 = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getGrp(): ?int
    {
        return $this->grp;
    }

    public function setGrp(?int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): int
    {
        return $this->sGrp;
    }

    public function setSGrp(int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getJcNoHs(): ?int
    {
        return $this->jcNoHs;
    }

    public function setJcNoHs(?int $value): static
    {
        $this->jcNoHs = $value;
        return $this;
    }

    public function getUpdated(): ?int
    {
        return $this->updated;
    }

    public function setUpdated(?int $value): static
    {
        $this->updated = $value;
        return $this;
    }
}
